/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ContentElementSchema;
import jade.content.schema.ObjectSchema;
import jade.util.leap.Iterator;

public class ContentElementListSchema
extends ContentElementSchema {
    public static final String BASE_NAME = "ContentElementList";
    private static ContentElementListSchema baseSchema = new ContentElementListSchema();

    private ContentElementListSchema() {
        super(BASE_NAME);
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    @Override
    public AbsObject newInstance() throws OntologyException {
        return new AbsContentElementList();
    }

    @Override
    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (!(abs instanceof AbsContentElementList)) {
            throw new OntologyException(abs + " is not an AbsContentElementList");
        }
        AbsContentElementList list = (AbsContentElementList)abs;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            AbsContentElement el = (AbsContentElement)it.next();
            ObjectSchema s = onto.getSchema(el.getTypeName());
            s.validate(el, onto);
        }
    }

    @Override
    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(ContentElementListSchema.getBaseSchema())) {
                return true;
            }
            return super.descendsFrom(s);
        }
        return false;
    }
}

