/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.Concept;
import jade.content.abs.AbsConceptSlotFunction;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;

public class ConceptSlotFunction
extends AbsConceptSlotFunction {
    private Concept concept;
    private Ontology onto;

    ConceptSlotFunction(String slotName, Concept concept, Ontology onto) {
        super(slotName);
        this.concept = concept;
        this.onto = onto;
    }

    public String getSlotName() {
        return this.getTypeName();
    }

    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public AbsObject getAbsObject(String name) {
        if ("CSF_CONCEPT".equals(name)) {
            try {
                return this.onto.fromObject(this.concept);
            }
            catch (OntologyException oe) {
                throw new RuntimeException("Error externalizing Concept " + this.concept.getClass().getName(), oe);
            }
        }
        return null;
    }

    @Override
    public String[] getNames() {
        return new String[]{"CSF_CONCEPT"};
    }

    @Override
    public boolean isGrounded() {
        return true;
    }

    @Override
    public int getCount() {
        return 1;
    }

    public Object apply() throws OntologyException {
        return this.apply(this.concept);
    }

    public Object apply(Concept c) throws OntologyException {
        if (this.concept.getClass().isAssignableFrom(c.getClass())) {
            return this.onto.getSlotValue(this.getTypeName(), c);
        }
        throw new OntologyException("Concept " + c.getClass() + " is not compatible with internal concept " + this.concept.getClass());
    }

    public void fill(Object val) throws OntologyException {
        this.fill(this.concept, val);
    }

    public void fill(Concept c, Object val) throws OntologyException {
        if (!this.concept.getClass().isAssignableFrom(c.getClass())) {
            throw new OntologyException("Concept " + c.getClass() + " is not compatible with internal concept " + this.concept.getClass());
        }
        this.onto.setSlotValue(this.getTypeName(), val, c);
    }
}

