/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsTerm;
import jade.content.onto.NotAnAggregate;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.ReflectiveIntrospector;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PrimitiveSchema;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.Iterator;
import java.lang.reflect.Method;

public class BCReflectiveIntrospector
extends ReflectiveIntrospector {
    @Override
    protected boolean isAggregateObject(Object obj) {
        return obj instanceof java.util.Iterator;
    }

    @Override
    public Object getSlotValue(String slotName, Object obj, ObjectSchema schema) throws OntologyException {
        ObjectSchema slotSchema = schema.getSchema(slotName);
        if (slotSchema != null) {
            if (slotSchema instanceof AggregateSchema) {
                return this.getAggregateSlotValue(slotName, obj);
            }
            return this.getScalarSlotValue(slotName, obj);
        }
        throw new OntologyException("No slot named " + slotName + " found in schema " + schema.getTypeName());
    }

    private Object getScalarSlotValue(String slotName, Object obj) throws OntologyException {
        String methodName = "get" + this.translateName(slotName);
        Method getMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
        return this.invokeAccessorMethod(getMethod, obj);
    }

    private Object getAggregateSlotValue(String slotName, Object obj) throws OntologyException {
        String methodName = "getAll" + this.translateName(slotName);
        Method getMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
        return this.invokeAccessorMethod(getMethod, obj);
    }

    @Override
    public void setSlotValue(String slotName, Object slotValue, Object obj, ObjectSchema schema) throws OntologyException {
        ObjectSchema slotSchema = schema.getSchema(slotName);
        if (slotSchema != null) {
            if (slotSchema instanceof AggregateSchema) {
                String methodName = "add" + this.translateName(slotName);
                Method addMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
                this.invokeAddMethod(addMethod, obj, slotValue);
            } else {
                String methodName = "set" + this.translateName(slotName);
                Method setMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
                this.invokeSetterMethod(setMethod, obj, slotValue);
            }
        } else {
            throw new OntologyException("No slot named " + slotName + " found in schema " + schema.getTypeName());
        }
    }

    private void invokeAddMethod(Method method, Object obj, Object value) throws OntologyException {
        try {
            Collection c = (Collection)value;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object ithValue = it.next();
                this.invokeSetterMethod(method, obj, ithValue);
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Can't apply recursively method " + method.getName() + " to object " + obj + " as value " + value + " is not a List", cce);
        }
    }

    @Override
    public void checkClass(ObjectSchema schema, Class javaClass, Ontology onto) throws OntologyException {
        String[] slotNames = schema.getNames();
        for (int i = 0; i < slotNames.length; ++i) {
            String sName = slotNames[i];
            ObjectSchema slotSchema = schema.getSchema(sName);
            String mName = this.translateName(sName);
            try {
                Class slotGetSetClass = slotSchema instanceof AggregateSchema ? this.checkGetAndSet2(mName, javaClass) : this.checkGetAndSet(mName, javaClass);
                if (!(slotSchema instanceof PrimitiveSchema)) {
                    Class slotClass = onto.getClassForElement(slotSchema.getTypeName());
                    if (slotClass == null || slotGetSetClass.isAssignableFrom(slotClass)) continue;
                    throw new OntologyException("Wrong class for schema: " + schema.getTypeName() + ". Slot " + sName + ": expected class=" + slotClass + ", Get/Set method class=" + slotGetSetClass);
                }
                String type = slotSchema.getTypeName();
                if (type.equals("BO_String")) {
                    if (slotGetSetClass.isAssignableFrom(String.class)) continue;
                    throw new OntologyException("Wrong class for schema: " + schema.getTypeName() + ". Slot " + sName + ": expected class=" + String.class + ", Get/Set method class=" + slotGetSetClass);
                }
                if (!type.equals("BO_Integer") || slotGetSetClass.equals(Integer.TYPE) || slotGetSetClass.equals(Integer.class) || slotGetSetClass.equals(Long.TYPE) || slotGetSetClass.equals(Long.class)) continue;
                throw new OntologyException("Wrong class for schema: " + schema.getTypeName() + ". Slot " + sName + ": expected class=INTEGER, Get/Set method class=" + slotGetSetClass);
            }
            catch (Exception e) {
                throw new OntologyException("Wrong class for schema: " + schema.getTypeName() + ". Slot " + sName + ": unexpected error. " + e.getMessage());
            }
        }
    }

    private Class checkGetAndSet(String name, Class c) throws OntologyException {
        Method getMethod = this.findMethodCaseInsensitive("get" + name, c);
        Method setMethod = this.findMethodCaseInsensitive("set" + name, c);
        Class<?>[] getParams = getMethod.getParameterTypes();
        if (getParams.length > 0) {
            throw new OntologyException("Wrong class: method " + getMethod.getName() + "() must take no arguments.");
        }
        Class<?> result = getMethod.getReturnType();
        Class<?>[] setParams = setMethod.getParameterTypes();
        if (setParams.length != 1 || !setParams[0].equals(result)) {
            throw new OntologyException("Wrong class: method " + setMethod.getName() + "() must take a single argument of type " + result.getName() + ".");
        }
        Class<?> setReturn = setMethod.getReturnType();
        if (!setReturn.equals(Void.TYPE)) {
            throw new OntologyException("Wrong class: method " + setMethod.getName() + "() must return void.");
        }
        return result;
    }

    private Class checkGetAndSet2(String name, Class c) throws OntologyException {
        Method getMethod = this.findMethodCaseInsensitive("getAll" + name, c);
        Method addMethod = this.findMethodCaseInsensitive("add" + name, c);
        Class result = this.getArgumentType(addMethod, 0);
        if (this.getArgumentLength(getMethod) != 0) {
            throw new OntologyException("Wrong class: method " + getMethod.getName() + "() must take no arguments.");
        }
        if (!this.getReturnType(getMethod).isAssignableFrom(Iterator.class)) {
            throw new OntologyException("Wrong class: method " + getMethod.getName() + "() must return a jade.util.leap.Iterator." + this.getReturnType(getMethod).toString());
        }
        if (this.getArgumentLength(addMethod) != 1) {
            throw new OntologyException("Wrong class: method " + addMethod.getName() + "() must take one argument.");
        }
        if (!this.getArgumentType(addMethod, 0).equals(result)) {
            throw new OntologyException("Wrong class: method " + addMethod.getName() + "() has the wrong argument type.");
        }
        if (!this.getReturnType(addMethod).equals(Void.TYPE)) {
            throw new OntologyException("Wrong class: method " + addMethod.getName() + "() must return a void.");
        }
        return result;
    }

    private Class getArgumentType(Method m, int no) {
        Class<?>[] setParams = m.getParameterTypes();
        return setParams[no];
    }

    private int getArgumentLength(Method m) {
        Class<?>[] getParams = m.getParameterTypes();
        return getParams.length;
    }

    private Class getReturnType(Method m) {
        return m.getReturnType();
    }

    @Override
    public AbsAggregate externalizeAggregate(String slotName, Object obj, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        if (!this.isAggregateObject(obj)) {
            throw new NotAnAggregate();
        }
        AbsAggregate absAggregateValue = null;
        java.util.Iterator it = (java.util.Iterator)obj;
        if (it.hasNext() || schema.isMandatory(slotName)) {
            String slotSchemaTypeName = schema.getSchema(slotName).getTypeName();
            absAggregateValue = new AbsAggregate(slotSchemaTypeName);
            try {
                while (it.hasNext()) {
                    absAggregateValue.add((AbsTerm)Ontology.externalizeSlotValue(it.next(), this, referenceOnto));
                }
            }
            catch (ClassCastException cce) {
                throw new OntologyException("Non term object in aggregate");
            }
        }
        return absAggregateValue;
    }

    @Override
    public Object internalizeAggregate(String slotName, AbsAggregate abs, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        ArrayList l = new ArrayList();
        for (int i = 0; i < abs.size(); ++i) {
            Object element = Ontology.internalizeSlotValue(abs.get(i), this, referenceOnto);
            Ontology.checkIsTerm(element);
            l.add(element);
        }
        return l;
    }
}

