/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.abs.AbsObjectImpl;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;

public class AbsReference
extends AbsObjectImpl
implements AbsTerm {
    private static final long serialVersionUID = 6167359403561714663L;
    public static final String REFERENCE_PREFIX = "&";
    public static final String REFERENCE_NAME_SEPARATOR = "#";
    public static final String REFERENCE_ATTRIBUTE_SEPARATOR = ".";
    private static Class absReferenceClass = null;

    public static AbsReference parse(String referenceStr) {
        if (referenceStr.charAt(0) == REFERENCE_PREFIX.charAt(0)) {
            referenceStr = referenceStr.substring(1);
        }
        String type = null;
        String name = null;
        int k = referenceStr.indexOf(REFERENCE_NAME_SEPARATOR);
        if (k > 0) {
            type = referenceStr.substring(0, k);
            name = referenceStr.substring(k + 1);
        } else {
            name = referenceStr;
        }
        return new AbsReference(name, type);
    }

    public AbsReference() {
        super("Reference");
    }

    public AbsReference(String name, String valueType) {
        super("Reference");
        this.setType(valueType);
        this.setName(name);
    }

    public void setName(String name) {
        this.set("Name", AbsPrimitive.wrap(name));
    }

    public void setType(String type) {
        this.set("ObjectType", AbsPrimitive.wrap(type));
    }

    public String getName() {
        AbsPrimitive abs = (AbsPrimitive)this.getAbsObject("Name");
        if (abs != null) {
            return abs.getString();
        }
        return null;
    }

    public String getType() {
        AbsPrimitive abs = (AbsPrimitive)this.getAbsObject("ObjectType");
        if (abs != null) {
            return abs.getString();
        }
        return null;
    }

    @Override
    public boolean isGrounded() {
        return false;
    }

    public static Class getJavaClass() {
        if (absReferenceClass == null) {
            try {
                absReferenceClass = Class.forName("jade.content.abs.AbsReference");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return absReferenceClass;
    }

    @Override
    public int getAbsType() {
        return 10;
    }

    public String getAttribute() {
        String n = this.getName();
        int k = n.indexOf(REFERENCE_ATTRIBUTE_SEPARATOR);
        if (k > 0) {
            return n.substring(k + 1);
        }
        return null;
    }

    public String getInstanceId() {
        String n = this.getName();
        int k = n.indexOf(REFERENCE_ATTRIBUTE_SEPARATOR);
        if (k > 0) {
            return n.substring(0, k);
        }
        return n;
    }

    public boolean isInstance() {
        return this.getName().indexOf(REFERENCE_ATTRIBUTE_SEPARATOR) > -1;
    }

    public boolean isAttribute() {
        return this.getName().indexOf(REFERENCE_ATTRIBUTE_SEPARATOR) == -1;
    }

    public static final String asString(String type, String name) {
        StringBuilder sb = new StringBuilder(REFERENCE_PREFIX);
        sb.append(type);
        sb.append(REFERENCE_NAME_SEPARATOR);
        sb.append(name);
        return sb.toString();
    }

    public static final String asString(String type, String id, String attribute) {
        StringBuilder sb = new StringBuilder(REFERENCE_PREFIX);
        sb.append(REFERENCE_NAME_SEPARATOR);
        sb.append(id);
        if (attribute != null) {
            sb.append(REFERENCE_ATTRIBUTE_SEPARATOR);
            sb.append(attribute);
        }
        return sb.toString();
    }
}

