/*****************************************************************
JADE - Java Agent DEvelopment Framework is a framework to develop 
multi-agent systems in compliance with the FIPA specifications.
Copyright (C) 2000 CSELT S.p.A. 

GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/


package jade.tools.introspector.gui;

import javax.swing.*;
import java.awt.event.*;

/**
   Listens to the events generated by the message table and pops up
   the context menu when needed.

   @author Andrea Squeri,Corti Denis,Ballestracci Paolo -  Universita` di Parma
*/
class TableMouseListener implements MouseListener {
  private MessagePanel parent;
  private TablePopupMenu popMenu;

  TableMouseListener() {
    popMenu= new TablePopupMenu();
  }

  // interface MouseListener
  public void mouseClicked(MouseEvent evt) {
    int button=evt.getModifiers();
    if(!(button==evt.BUTTON1_MASK)){
      popMenu.setTable((JTable)evt.getSource());
      popMenu.show(evt.getComponent(),evt.getX(),evt.getY());
    }
  }

  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}
  public void mousePressed(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}

}
