/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.ziptotext;

import de.elnarion.util.ziptotext.App;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.codec.binary.Base64OutputStream;
import picocli.CommandLine;

@CommandLine.Command(name="zipToText", mixinStandardHelpOptions=true, description={"Zips a folder, converts it to a base64 encoded and splitted textfile and writes the files to a target."})
public class ZipToTextCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private App app;
    @CommandLine.Parameters(index="0", description={"The file/directory to zip."})
    private File file;
    @CommandLine.Parameters(index="1", description={"The target file."})
    private File targetfile;
    @CommandLine.Option(names={"-p", "--password"}, description={"Use a password for zipping."})
    private String password = null;
    @CommandLine.Option(names={"-s", "--max-size-in-mb"}, description={"Maximum size for the target text file."})
    private Double maxSize = null;
    @CommandLine.Option(names={"-vb", "--verbose"}, description={"Write all actions to console and preserve tempfiles."})
    private Boolean verbose = false;
    private static final int BUFFER_SIZE = 3072;

    @Override
    public Integer call() throws Exception {
        char[] passwordChars = null;
        ZipParameters parameters = null;
        if (this.password != null) {
            parameters = new ZipParameters();
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.AES);
            passwordChars = this.password.toCharArray();
        }
        if (this.targetfile.exists()) {
            this.targetfile.delete();
        }
        this.targetfile.getParentFile().mkdirs();
        ZipFile zipFile = new ZipFile(this.targetfile, passwordChars);
        if (this.verbose.booleanValue()) {
            System.out.println("zipping " + this.file.getAbsolutePath());
        }
        if (this.file.isDirectory()) {
            zipFile.addFolder(this.file, parameters);
        } else {
            zipFile.addFile(this.file, parameters);
        }
        File textTargetFile = this.writeTargetToText();
        if (!this.verbose.booleanValue()) {
            this.targetfile.delete();
        }
        if (this.maxSize != null) {
            if (this.verbose.booleanValue()) {
                System.out.println("splitting");
            }
            this.splitFile(textTargetFile);
            if (!this.verbose.booleanValue()) {
                textTargetFile.delete();
            }
        } else {
            if (this.verbose.booleanValue()) {
                System.out.println("not splitting");
            }
            textTargetFile.renameTo(new File(textTargetFile.getAbsolutePath() + ".1.txt"));
        }
        return 0;
    }

    private File writeTargetToText() throws FileNotFoundException, IOException {
        try (FileInputStream input = new FileInputStream(this.targetfile);){
            File file;
            try (BufferedInputStream in = new BufferedInputStream(input, 3072);){
                file = this.writeTargetToTextEncoded(in);
            }
            return file;
        }
    }

    private File writeTargetToTextEncoded(BufferedInputStream in) throws IOException, FileNotFoundException {
        int len = 0;
        byte[] chunk = new byte[3072];
        File textTargetFile = new File(this.targetfile.getCanonicalPath() + ".txt");
        try (Base64OutputStream bos = new Base64OutputStream((OutputStream)new FileOutputStream(textTargetFile));){
            while ((len = in.read(chunk)) == 3072) {
                bos.write(chunk);
            }
            if (len > 0) {
                chunk = Arrays.copyOf(chunk, len);
                bos.write(chunk);
            }
        }
        return textTargetFile;
    }

    public List<Path> splitFile(File paramSourceFile) throws IOException {
        ArrayList<Path> partFiles = new ArrayList<Path>();
        long sourceSize = Files.size(paramSourceFile.toPath());
        long bytesPerSplit = (long)(1048576.0 * this.maxSize);
        long numSplits = sourceSize / bytesPerSplit;
        long remainingBytes = sourceSize % bytesPerSplit;
        int position = 0;
        if (this.verbose.booleanValue()) {
            System.out.println("Number of Splits " + numSplits);
        }
        try (RandomAccessFile sourceFile = new RandomAccessFile(paramSourceFile, "r");
             FileChannel sourceChannel = sourceFile.getChannel();){
            while ((long)position < numSplits) {
                this.writePartToFile(bytesPerSplit, (long)position * bytesPerSplit, sourceChannel, partFiles, position, paramSourceFile);
                ++position;
            }
            if (remainingBytes > 0L) {
                this.writePartToFile(remainingBytes, (long)position * bytesPerSplit, sourceChannel, partFiles, position, paramSourceFile);
            }
        }
        return partFiles;
    }

    private void writePartToFile(long byteSize, long position, FileChannel sourceChannel, List<Path> partFiles, int counter, File paramSourceFile) throws IOException {
        Path fileName = new File(this.targetfile.getAbsolutePath() + "." + (counter + 1) + ".txt").toPath();
        if (this.verbose.booleanValue()) {
            System.out.println("writing part to " + fileName.toString());
        }
        try (RandomAccessFile toFile = new RandomAccessFile(fileName.toFile(), "rw");
             FileChannel toChannel = toFile.getChannel();){
            sourceChannel.position(position);
            toChannel.transferFrom(sourceChannel, 0L, byteSize);
        }
        partFiles.add(fileName);
    }
}

