/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.ziptotext;

import de.elnarion.util.ziptotext.App;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import picocli.CommandLine;

@CommandLine.Command(name="textToZip", mixinStandardHelpOptions=true, description={"Merges base 64 encoded text files, creates a zip from it and unzips the result to the target directory."})
public class TextToZipCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    private App app;
    @CommandLine.Parameters(index="0", description={"The first text file."})
    private File file;
    @CommandLine.Parameters(index="1", description={"The target directory."})
    private File targetdirectory;
    @CommandLine.Option(names={"-p", "--password"}, description={"Use a password for unzipping."})
    private String password = null;
    @CommandLine.Option(names={"-vb", "--verbose"}, description={"Write all actions to console and preserve tempfiles."})
    private Boolean verbose = false;
    private File tempZipFile;

    @Override
    public Integer call() throws Exception {
        int lastIndex;
        this.tempZipFile = new File(this.targetdirectory, UUID.randomUUID().toString() + ".zip");
        this.tempZipFile.getParentFile().mkdirs();
        String filename = this.file.getName();
        char[] passwordCharset = null;
        if (this.password != null) {
            passwordCharset = this.password.toCharArray();
        }
        if ((lastIndex = filename.lastIndexOf(".1.txt")) > 0) {
            filename = filename.substring(0, lastIndex);
            int counter = 1;
            boolean unfinished = true;
            ArrayList<FileInputStream> inputStreams = new ArrayList<FileInputStream>();
            do {
                File nextFile;
                if ((nextFile = new File(this.file.getParentFile(), filename + "." + counter + ".txt")).exists()) {
                    inputStreams.add(new FileInputStream(nextFile));
                } else {
                    unfinished = false;
                }
                ++counter;
            } while (unfinished);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(inputStreams));
            this.writeTextToZipTarget(sequenceInputStream);
            ZipFile zipFile = new ZipFile(this.tempZipFile, passwordCharset);
            zipFile.extractAll(this.targetdirectory.getAbsolutePath());
            if (!this.verbose.booleanValue()) {
                this.tempZipFile.delete();
            }
        }
        return null;
    }

    private void writeTextToZipTarget(InputStream paramSource) throws IOException {
        Base64InputStream bis = new Base64InputStream(paramSource);
        IOUtils.copy((InputStream)bis, (OutputStream)new FileOutputStream(this.tempZipFile, true));
    }
}

