/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.sequencediagram;

import de.elnarion.test.sequence.t0001.CallerA;
import de.elnarion.test.sequence.t0002.CallerClassA;
import de.elnarion.test.sequence.t0003jakarta.MovieService;
import de.elnarion.test.sequence.t0004.User;
import de.elnarion.test.sequence.t0005.SequenceStarterClass;
import de.elnarion.util.plantuml.generator.sequencediagram.PlantUMLSequenceDiagramGenerator;
import de.elnarion.util.plantuml.generator.sequencediagram.config.PlantUMLSequenceDiagramConfigBuilder;
import de.elnarion.util.plantuml.generator.sequencediagram.exception.NotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class PlantUMLSequenceDiagramGeneratorTest {
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    PlantUMLSequenceDiagramGeneratorTest() {
    }

    @Test
    void test0001BasicSequenceDiagram() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerA.class.getName(), "callSomething");
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0001_basic_caller_test.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0001BasicSequenceDiagramWithNotFoundException() {
        Assertions.assertThrows(NotFoundException.class, () -> {
            PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder("de.elnarion.test.DoesNotExistClass", "callSomethingDoesNotExist");
            PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
            generator.generateDiagramText();
        });
    }

    @Test
    void test0001BasicSequenceDiagramWithLongClassNames() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerA.class.getName(), "callSomething").withUseShortClassName(false);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0001_basic_caller_with_long_class_names.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0001BasicSequenceDiagramWithShowReturnType() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerA.class.getName(), "callSomething").withShowReturnTypes(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0001_basic_caller_test_with_return_types.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0001BasicSequenceDiagramWithShowReturnTypeAndLongClassNames() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerA.class.getName(), "callSomething").withShowReturnTypes(true).withUseShortClassName(false);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0001_basic_caller_test_with_return_types_and_long_class_names.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0002BasicSuperClassSequenceDiagram() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerClassA.class.getName(), "testSomething");
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0002_basic_super_class_sequence_diagram.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0002BasicSuperClassSequenceDiagramWithHideSuperClass() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(CallerClassA.class.getName(), "testSomething").withHideSuperClass(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0002_basic_super_class_sequence_diagram_with_hide_super_class.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @ParameterizedTest
    @ValueSource(classes={de.elnarion.test.sequence.t0003.MovieService.class, MovieService.class})
    void test0003JPASequenceDiagramWithoutOptions(Class<?> classUnderTest) throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(classUnderTest.getName(), "doSomeBusiness");
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0003_jpa_test_without_options.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @ParameterizedTest
    @ValueSource(classes={de.elnarion.test.sequence.t0003.MovieService.class, MovieService.class})
    void test0003JPASequenceDiagramWithStandardClasses(Class<?> classUnderTest) throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(classUnderTest.getName(), "doSomeBusiness").withIgnoreStandardClasses(false);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0003_jpa_test_with_standard_classes.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @ParameterizedTest
    @ValueSource(classes={de.elnarion.test.sequence.t0003.MovieService.class, MovieService.class})
    void test0003JPASequenceDiagramWithIgnoreJPAEntities(Class<?> classUnderTest) throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(classUnderTest.getName(), "doSomeBusiness").withIgnoreJPAEntities(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0003_jpa_test_with_ignore_jpa_entities.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @ParameterizedTest
    @ValueSource(classes={de.elnarion.test.sequence.t0003.MovieService.class, MovieService.class})
    void test0003JPASequenceDiagramWithIgnoreJPAEntitiesAndHideMethodNames(Class<?> classUnderTest) throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(classUnderTest.getName(), "doSomeBusiness").withIgnoreJPAEntities(true).withHideMethodName(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0003_jpa_test_with_ignore_jpa_entities_and_hide_method_names.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0004SequenceDiagramWithBlacklistedClasses() throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(User.class.getName(), "interaction").withClassBlacklistRegexp(".*(Controller|Model)");
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0004_sequence_diagram_with_blacklisted_classes.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0004SequenceDiagramWithBlacklistedMethod() throws IOException, NotFoundException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(User.class.getName(), "interaction").withMethodBlacklistRegexp("getData");
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0004_sequence_diagram_with_blacklisted_method.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0004Classloader() throws Exception {
        String testClassPath = "file:///" + System.getProperty("user.dir") + "/src/test/classes/";
        URL[] classesURLs = new URL[]{new URL(testClassPath)};
        URLClassLoader customClassLoader = new URLClassLoader(classesURLs);
        customClassLoader.loadClass("de.elnarion.test.sequence.t0004.User");
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(User.class.getName(), "interaction").withClassloader((ClassLoader)customClassLoader);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0004_sequence_diagram_with_custom_classloader.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0005CircularMethodCalls() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(SequenceStarterClass.class.getName(), "startSequence").withIgnoreStandardClasses(true).withUseShortClassName(true).withShowReturnTypes(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0005_sequence_diagram_with_circular_method_calls.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }

    @Test
    void test0005RecursiveMethodCalls() throws NotFoundException, IOException {
        PlantUMLSequenceDiagramConfigBuilder builder = new PlantUMLSequenceDiagramConfigBuilder(SequenceStarterClass.class.getName(), "recursiveCall").withIgnoreStandardClasses(true).withUseShortClassName(true).withShowReturnTypes(true);
        PlantUMLSequenceDiagramGenerator generator = new PlantUMLSequenceDiagramGenerator(builder.build());
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("sequence/0005_sequence_diagram_with_recursive_calls.txt")), (Charset)StandardCharsets.UTF_8);
        String generatedDiagram = generator.generateDiagramText();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)generatedDiagram), () -> Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)generatedDiagram.replaceAll("\\s+", ""))});
    }
}

