/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.coding;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.library.GeneralCodingRules;
import org.junit.jupiter.api.Test;

class CodingTest {
    private final JavaClasses classes = new ClassFileImporter().importPackages(new String[]{"de.elnarion.util.plantuml"});

    CodingTest() {
    }

    @Test
    void testClassesShouldNotAccessStandardStreamsDefinedByHand() {
        ArchRuleDefinition.noClasses().should(GeneralCodingRules.ACCESS_STANDARD_STREAMS).check(this.classes);
    }

    @Test
    void testClassesShouldNotAccessStandardStreamsFromLibrary() {
        GeneralCodingRules.NO_CLASSES_SHOULD_ACCESS_STANDARD_STREAMS.check(this.classes);
    }

    @Test
    void testClassesShouldNotThrowGenericExceptions() {
        GeneralCodingRules.NO_CLASSES_SHOULD_THROW_GENERIC_EXCEPTIONS.check(this.classes);
    }

    @Test
    void testClassesShouldNotUseJavaUtilLogging() {
        GeneralCodingRules.NO_CLASSES_SHOULD_USE_JAVA_UTIL_LOGGING.check(this.classes);
    }

    @Test
    void testClassesShouldNotUseJodatime() {
        GeneralCodingRules.NO_CLASSES_SHOULD_USE_JODATIME.check(this.classes);
    }

    @Test
    void testClassesShouldNotUseFieldInjection() {
        GeneralCodingRules.NO_CLASSES_SHOULD_USE_FIELD_INJECTION.check(this.classes);
    }
}

