/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.classdiagram;

import de.elnarion.util.plantuml.generator.classdiagram.PlantUMLClassDiagramGenerator;
import de.elnarion.util.plantuml.generator.classdiagram.config.ClassifierType;
import de.elnarion.util.plantuml.generator.classdiagram.config.PlantUMLClassDiagramConfig;
import de.elnarion.util.plantuml.generator.classdiagram.config.PlantUMLClassDiagramConfigBuilder;
import de.elnarion.util.plantuml.generator.classdiagram.config.VisibilityType;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;

class PlantUMLClassDiagramGeneratorTest {
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    PlantUMLClassDiagramGeneratorTest() {
    }

    private static Stream<Arguments> provideBaseRenderingTests() {
        return Stream.of(Arguments.of((Object[])new Object[]{"de.elnarion.test.domain.t0002", "class/0002_class_types.txt"}), Arguments.of((Object[])new Object[]{"de.elnarion.test.domain.t0003", "class/0003_class_relationships.txt"}), Arguments.of((Object[])new Object[]{"de.elnarion.test.domain.t0005", "class/0005_class_methods.txt"}));
    }

    private static String getTestResultString() {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0006.pck1");
        scanPackages.add("de.elnarion.test.domain.t0006.pck2");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        return generator.generateDiagramText();
    }

    @Test
    void test0001GenerateDiagram() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0001");
        ArrayList<String> hideClasses = new ArrayList<String>();
        hideClasses.add("de.elnarion.test.domain.ChildB");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages).withHideClasses(hideClasses);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0001_general_diagram.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @ParameterizedTest
    @MethodSource(value={"provideBaseRenderingTests"})
    void testBaseRendering(String paramScanpackage, String paramCompareTextFile) throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add(paramScanpackage);
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(paramCompareTextFile)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0004ClassFields() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0004");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(".*TestReference", scanPackages);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0004_class_fields.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0006DifferentPackages() throws IOException {
        String result = PlantUMLClassDiagramGeneratorTest.getTestResultString();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0006_different_packages.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0007HideParameters() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0007");
        ArrayList<String> hideClasses = new ArrayList<String>();
        hideClasses.add("de.elnarion.test.domain.t0007.ClassB");
        hideClasses.add("de.elnarion.test.domain.t0007.ClassC");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages).withHideClasses(hideClasses).withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0007_hide_parameters.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0008Classloader() throws Exception {
        String filename = "class/0008_classloader_test.txt";
        String testClassPath = "file:///" + System.getProperty("user.dir") + "/src/test/classes/";
        URL[] classesURLs = new URL[]{new URL(testClassPath)};
        URLClassLoader customClassLoader = new URLClassLoader(classesURLs);
        customClassLoader.loadClass("de.elnarion.maven.plugin.plantuml.generator.test.domain.ChildA");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.maven.plugin.plantuml.generator.test.domain");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages).withClassLoader((ClassLoader)customClassLoader).withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0009JarPackage() throws Exception {
        String filename = "class/0009_jar_test.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("org.apache.commons.io.monitor");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages).withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0011JarPackageWithBlacklist() throws Exception {
        String filename = "class/0011_jar_test_blacklist.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("org.apache.commons.io.monitor");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(".*FileEn.*", scanPackages).withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0010ParameterizedAggregationType() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0010");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanPackages).withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.getClass().getClassLoader().getResource("class/0010_parameterized_aggregation_type.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0012JarPackageWithWhitelist() throws Exception {
        String filename = "class/0012_jar_whitelist.txt";
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(null, "org\\.apache\\.commons\\.io.*FileAl.*").withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0012JarPackageWithWhitelistWithoutScanpackagesParameter() throws Exception {
        String filename = "class/0012_jar_whitelist.txt";
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder("org\\.apache\\.commons\\.io.*FileAl.*").withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0012JarPackageWithWhitelistWithScanpackagesParameterLimitedToBasePackage() throws Exception {
        String filename = "class/0012_jar_whitelist.txt";
        ArrayList<String> scanpackages = new ArrayList<String>();
        scanpackages.add("org.apache.commons.io");
        PlantUMLClassDiagramConfigBuilder configBuilder = new PlantUMLClassDiagramConfigBuilder(scanpackages, "org\\.apache\\.commons\\.io.*FileAl.*").withHideFieldsParameter(true).withHideMethods(true);
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(configBuilder.build());
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0013MaxVisibilityFields() throws Exception {
        String filename = "class/0013_max_visibility_fields_public.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0013");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumFieldVisibility(VisibilityType.PUBLIC).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumFieldVisibility(VisibilityType.PROTECTED).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0013_max_visibility_fields_protected.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumFieldVisibility(VisibilityType.PACKAGE_PRIVATE).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0013_max_visibility_fields_package_private.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumFieldVisibility(VisibilityType.PRIVATE).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0013_max_visibility_fields_private.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0014MaxVisibilityMethods() throws Exception {
        String filename = "class/0014_max_visibility_methods_public.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0014.Testclass");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0014");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumMethodVisibility(VisibilityType.PUBLIC).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumMethodVisibility(VisibilityType.PROTECTED).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0014_max_visibility_methods_protected.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumMethodVisibility(VisibilityType.PACKAGE_PRIVATE).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0014_max_visibility_methods_package_private.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
        config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMaximumMethodVisibility(VisibilityType.PRIVATE).build();
        generator = new PlantUMLClassDiagramGenerator(config);
        result = generator.generateDiagramText();
        filename = "class/0014_max_visibility_methods_private.txt";
        expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0015RemoveMethods() throws Exception {
        String filename = "class/0015_remove_methods.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0015.Testclass1");
        this.classLoader.loadClass("de.elnarion.test.domain.t0015.Testclass2");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0015");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withRemoveMethods(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0016RemoveFields() throws Exception {
        String filename = "class/0016_remove_fields.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0016.Testclass1");
        this.classLoader.loadClass("de.elnarion.test.domain.t0016.Testclass2");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0016");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withRemoveFields(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0017BlacklistMethods() throws Exception {
        String filename = "class/0017_blacklist_methods.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0017.Testclass1");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0017");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMethodBlacklistRegexp(".*doSomething1.*").build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0017BlacklistMethodsWithEmptyBlacklist() throws Exception {
        String filename = "class/0017_blacklist_methods_empty_parameter.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0017.Testclass1");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0017");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withMethodBlacklistRegexp("").build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0018BlacklistFields() throws Exception {
        String filename = "class/0018_blacklist_fields.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0018.Testclass1");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0018");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withFieldBlacklistRegexp("test1").build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0019IgnoreClassifierFields() throws Exception {
        String filename = "class/0019_ignore_classifier_fields.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0019");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).addFieldClassifierToIgnore(ClassifierType.STATIC).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0019IgnoreMultipleClassifierFields() throws Exception {
        String filename = "class/0019_ignore_classifier_fields.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0019");
        ArrayList<ClassifierType> classifiers = new ArrayList<ClassifierType>();
        classifiers.add(ClassifierType.STATIC);
        classifiers.add(ClassifierType.ABSTRACT);
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).addFieldClassifiersToIgnore(classifiers).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0020IgnoreClassifierMethods() throws Exception {
        String filename = "class/0020_ignore_classifier_methods.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0020.Testclass");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0020");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).addMethodClassifierToIgnore(ClassifierType.STATIC).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0020IgnoreMultipleClassifierMethods() throws Exception {
        String filename = "class/0020_ignore_multiple_classifier_methods.txt";
        this.classLoader.loadClass("de.elnarion.test.domain.t0020.Testclass");
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0020");
        ArrayList<ClassifierType> classifiers = new ArrayList<ClassifierType>();
        classifiers.add(ClassifierType.STATIC);
        classifiers.add(ClassifierType.ABSTRACT);
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).addMethodClassifiersToIgnore(classifiers).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @ParameterizedTest
    @CsvSource(value={"class/0021_jpa_annotations.txt,de.elnarion.test.domain.t0021", "class/0021_jpa_annotations_jakarta.txt,de.elnarion.test.domain.t0021jakarta"})
    void test0021JPAAnnotations(String expectedFileName, String packageUnderTest) throws Exception {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add(packageUnderTest);
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withJPAAnnotations(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(expectedFileName)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0022PrivateFinalFields() throws Exception {
        String filename = "class/0022_private_final_field.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0022");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(".*\\$.*|com.xx.common.converter.BeanConverter|.*\\.metamodel\\..*", scanPackages).withHideMethods(false).withHideFieldsParameter(false).withMaximumFieldVisibility(VisibilityType.PRIVATE).withMaximumMethodVisibility(VisibilityType.PUBLIC).withMethodBlacklistRegexp("(hashCode|equals)").build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0023GenerateDiagramWithAdditionalPlantUmlConfigs() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0023");
        ArrayList<String> additionalPlantUmlConfigs = new ArrayList<String>();
        additionalPlantUmlConfigs.add("left to right direction");
        additionalPlantUmlConfigs.add("scale 2/3");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).addAdditionalPlantUmlConfigs(additionalPlantUmlConfigs).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0023_additional-plant-uml-configs.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0024ClassRelationships() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0024");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withRemoveMethods(false).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0024_class_relationships.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0025UseShortClassNames() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0025");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withUseShortClassNames(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0025_use_short_classnames.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0025UseShortClassNamesInFieldsAndMethods() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0025");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withUseShortClassNamesInFieldsAndMethods(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0025_use_short_classnames_in_fields_and_methods.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0026AggregateRelationships() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0026");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withUseShortClassNamesInFieldsAndMethods(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0026_different_aggregate_relationships.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0027UseSmetana() throws IOException {
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0027");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withUseSmetana(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource("class/0027_use_smetana.txt")), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }

    @Test
    void test0028JavaxValidationAnnotations() throws Exception {
        String filename = "class/0028_javax_validation_annotations.txt";
        ArrayList<String> scanPackages = new ArrayList<String>();
        scanPackages.add("de.elnarion.test.domain.t0028");
        PlantUMLClassDiagramConfig config = new PlantUMLClassDiagramConfigBuilder(scanPackages).withJavaxValidationAnnotations(true).build();
        PlantUMLClassDiagramGenerator generator = new PlantUMLClassDiagramGenerator(config);
        String result = generator.generateDiagramText();
        String expectedDiagramText = IOUtils.toString((URL)Objects.requireNonNull(this.classLoader.getResource(filename)), (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)result);
        Assertions.assertNotNull((Object)expectedDiagramText);
        Assertions.assertEquals((Object)expectedDiagramText.replaceAll("\\s+", ""), (Object)result.replaceAll("\\s+", ""));
    }
}

