/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.classdiagram;

import de.elnarion.util.plantuml.generator.classdiagram.PlantUMLDiagramElement;
import de.elnarion.util.plantuml.generator.classdiagram.RelationshipType;

public class UMLRelationship
implements PlantUMLDiagramElement {
    private String fromMultiplicity;
    private String toMultiplicity;
    private String name;
    private String fromName;
    private String toName;
    private RelationshipType relationshiptype;

    public UMLRelationship(String paramFromMultiplicity, String paramToMultiplicity, String paramName, String paramFromName, String paramToName, RelationshipType paramRelationshipType) {
        this.fromMultiplicity = paramFromMultiplicity;
        this.toMultiplicity = paramToMultiplicity;
        this.name = paramName;
        this.fromName = paramFromName;
        this.toName = paramToName;
        this.relationshiptype = paramRelationshipType;
    }

    public String getFromMultiplicity() {
        return this.fromMultiplicity;
    }

    public String getToMultiplicity() {
        return this.toMultiplicity;
    }

    public String getName() {
        return this.name;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getToName() {
        return this.toName;
    }

    public RelationshipType getRelationshiptype() {
        return this.relationshiptype;
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fromName);
        builder.append(" ");
        if (this.fromMultiplicity != null) {
            builder.append("\"");
            builder.append(this.fromMultiplicity);
            builder.append("\" ");
        }
        switch (this.relationshiptype) {
            case AGGREGATION: {
                builder.append("o--");
                break;
            }
            case ASSOCIATION: {
                builder.append("--");
                break;
            }
            case COMPOSITION: {
                builder.append("*--");
                break;
            }
            case DIRECTED_ASSOCIATION: {
                builder.append("-->");
                break;
            }
            case INHERITANCE: {
                builder.append("--|>");
                break;
            }
            case REALIZATION: {
                builder.append("..|>");
                break;
            }
        }
        builder.append(" ");
        if (this.toMultiplicity != null) {
            builder.append("\"");
            builder.append(this.toMultiplicity);
            builder.append("\" ");
        }
        builder.append(" ");
        builder.append(this.toName);
        if (this.name != null) {
            builder.append(" : ");
            builder.append(this.name);
        }
        return builder.toString();
    }
}

