/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.classdiagram;

import de.elnarion.util.plantuml.generator.PlantUMLUtil;
import de.elnarion.util.plantuml.generator.classdiagram.ClassifierType;
import de.elnarion.util.plantuml.generator.classdiagram.PlantUMLDiagramElement;
import de.elnarion.util.plantuml.generator.classdiagram.VisibilityType;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UMLMethod
implements PlantUMLDiagramElement {
    private ClassifierType classifierType;
    private VisibilityType visibilityType;
    private String resultType;
    private Map<String, String> parametersAndTypes;
    private String name;
    private List<String> stereotypes;

    public UMLMethod(ClassifierType paramClassifierType, VisibilityType paramVisibility, String paramResultType, String paramName, Map<String, String> paramParametersAndType, List<String> paramStereotypes) {
        this.classifierType = paramClassifierType;
        this.visibilityType = paramVisibility;
        this.resultType = paramResultType;
        this.name = paramName;
        this.parametersAndTypes = paramParametersAndType;
        this.stereotypes = paramStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public ClassifierType getClassifierType() {
        return this.classifierType;
    }

    public VisibilityType getVisibilityType() {
        return this.visibilityType;
    }

    public String getResultType() {
        return this.resultType;
    }

    public Map<String, String> getParametersAndTypes() {
        return this.parametersAndTypes;
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append("{method} ");
        switch (this.classifierType) {
            case ABSTRACT_STATIC: {
                builder.append(" {static} {abstract}");
                break;
            }
            case ABSTRACT: {
                builder.append(" {abstract} ");
                break;
            }
            case STATIC: {
                builder.append(" {static} ");
                break;
            }
        }
        builder.append(PlantUMLUtil.getVisibilityText(this.visibilityType));
        builder.append(this.name);
        builder.append(" (");
        if (this.parametersAndTypes != null && !this.parametersAndTypes.isEmpty()) {
            Set<Map.Entry<String, String>> entries = this.parametersAndTypes.entrySet();
            boolean firstIteration = true;
            for (Map.Entry<String, String> entry : entries) {
                if (!firstIteration) {
                    builder.append(",");
                }
                builder.append(" ");
                builder.append(entry.getKey());
                builder.append(" : ");
                builder.append(entry.getValue());
                builder.append(" ");
                firstIteration = false;
            }
        }
        builder.append(")");
        if (this.resultType != null) {
            builder.append(" : ");
            builder.append(this.resultType);
        }
        if (this.stereotypes != null) {
            for (String stereotype : this.stereotypes) {
                builder.append(" <<");
                builder.append(stereotype);
                builder.append(">> ");
            }
        }
        return builder.toString();
    }
}

