/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.classdiagram;

import de.elnarion.util.plantuml.generator.PlantUMLUtil;
import de.elnarion.util.plantuml.generator.classdiagram.ClassifierType;
import de.elnarion.util.plantuml.generator.classdiagram.PlantUMLDiagramElement;
import de.elnarion.util.plantuml.generator.classdiagram.VisibilityType;

public class UMLField
implements PlantUMLDiagramElement {
    private String type;
    private String name;
    private ClassifierType classifierType;
    private VisibilityType visibilityType;

    public UMLField(ClassifierType paramClassifierType, VisibilityType paramVisibilityType, String paramName, String paramType) {
        this.type = paramType;
        this.name = paramName;
        this.classifierType = paramClassifierType;
        this.visibilityType = paramVisibilityType;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ClassifierType getClassifierType() {
        return this.classifierType;
    }

    public VisibilityType getVisibilityType() {
        return this.visibilityType;
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append("{field} ");
        if (this.classifierType != null && this.classifierType == ClassifierType.STATIC) {
            builder.append("{static} ");
        }
        builder.append(PlantUMLUtil.getVisibilityText(this.visibilityType));
        builder.append(this.name);
        if (this.type != null) {
            builder.append(" : ");
            builder.append(this.type);
        }
        return builder.toString();
    }
}

