/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator.classdiagram;

import de.elnarion.util.plantuml.generator.classdiagram.ClassType;
import de.elnarion.util.plantuml.generator.classdiagram.PlantUMLDiagramElement;
import de.elnarion.util.plantuml.generator.classdiagram.UMLField;
import de.elnarion.util.plantuml.generator.classdiagram.UMLMethod;
import de.elnarion.util.plantuml.generator.classdiagram.VisibilityType;
import de.elnarion.util.plantuml.generator.util.UMLMethodComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UMLClass
implements PlantUMLDiagramElement {
    private VisibilityType visibilityType;
    private String name;
    private ClassType classType;
    private List<UMLField> fields;
    private List<UMLMethod> methods;
    private List<String> stereotypes;

    public UMLClass(VisibilityType paramVisibilityType, ClassType paramClassType, List<UMLField> paramFields, List<UMLMethod> paramMethods, String paramName, List<String> paramStereotypes) {
        this.visibilityType = paramVisibilityType;
        this.classType = paramClassType;
        this.name = paramName;
        this.fields = paramFields;
        this.methods = paramMethods;
        this.stereotypes = paramStereotypes;
    }

    public List<String> getStereotypes() {
        return this.stereotypes;
    }

    public VisibilityType getVisibilityType() {
        return this.visibilityType;
    }

    public String getName() {
        return this.name;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public List<UMLField> getFields() {
        return this.fields;
    }

    public List<UMLMethod> getMethods() {
        return this.methods;
    }

    @Override
    public String getDiagramText() {
        boolean isAnnotation = false;
        StringBuilder builder = new StringBuilder();
        isAnnotation = this.addClassType(isAnnotation, builder);
        builder.append(this.name);
        this.addStereotypes(builder);
        if (!isAnnotation) {
            builder.append(" {");
            builder.append(System.lineSeparator());
            if (this.fields != null && !this.fields.isEmpty()) {
                Collections.sort(this.fields, new Comparator<UMLField>(){

                    @Override
                    public int compare(UMLField o1, UMLField o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (UMLField field : this.fields) {
                    builder.append("\t");
                    builder.append(field.getDiagramText());
                    builder.append(System.lineSeparator());
                }
            }
            if (this.methods != null && !this.methods.isEmpty()) {
                Collections.sort(this.methods, new UMLMethodComparator());
                for (UMLMethod method : this.methods) {
                    builder.append("\t");
                    builder.append(method.getDiagramText());
                    builder.append(System.lineSeparator());
                }
            }
            builder.append("}");
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    private void addStereotypes(StringBuilder builder) {
        if (this.stereotypes != null) {
            for (String stereotype : this.stereotypes) {
                builder.append(" <<");
                builder.append(stereotype);
                builder.append(" >> ");
            }
        }
    }

    private boolean addClassType(boolean isAnnotation, StringBuilder builder) {
        switch (this.classType) {
            case ABSTRACT_CLASS: {
                builder.append("abstract class ");
                break;
            }
            case ANNOTATION: {
                builder.append("annotation ");
                isAnnotation = true;
                break;
            }
            case CLASS: {
                builder.append("class ");
                break;
            }
            case ENUM: {
                builder.append("enum ");
                break;
            }
            case INTERFACE: {
                builder.append("interface ");
                break;
            }
        }
        return isAnnotation;
    }

    public void addField(UMLField paramField) {
        if (this.fields == null) {
            this.fields = new ArrayList<UMLField>();
        }
        this.fields.add(paramField);
    }

    public void addMethod(UMLMethod paramMethod) {
        if (this.methods == null) {
            this.methods = new ArrayList<UMLMethod>();
        }
        this.methods.add(paramMethod);
    }
}

