/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.html2pdf;

import de.elnarion.util.docconverter.api.exception.ConversionException;
import de.elnarion.util.docconverter.spi.DocConverter;
import de.elnarion.util.docconverter.spi.InputType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class HTML2PDFConverter
implements DocConverter {
    private static Map<String, Set<String>> supportedMimetypes = null;
    private Map<String, Object> configurationParameters;

    public HTML2PDFConverter(Map<String, Object> paramConfigurationParameters) {
        this.configurationParameters = paramConfigurationParameters;
    }

    public static synchronized Map<String, Set<String>> getSupportedConversion() {
        if (supportedMimetypes == null) {
            supportedMimetypes = new HashMap<String, Set<String>>();
            HashSet<String> targetMimetypes = new HashSet<String>();
            targetMimetypes.add("application/pdf");
            supportedMimetypes.put("text/html", targetMimetypes);
            supportedMimetypes.put("application/xhtml+xml", targetMimetypes);
        }
        return supportedMimetypes;
    }

    public Future<List<InputStream>> convertStreams(final List<InputStream> source, final String paramSourceMimeType, String paramTargetMimeType) throws ConversionException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        return exec.submit(new Callable<List<InputStream>>(){

            @Override
            public List<InputStream> call() throws Exception {
                ArrayList<InputStream> resultList = new ArrayList<InputStream>();
                for (InputStream is : source) {
                    resultList.add(HTML2PDFConverter.this.convertToInputStream(is, paramSourceMimeType));
                }
                return resultList;
            }
        });
    }

    private InputStream convertToInputStream(InputStream source, String paramSourceMimeType) throws ConversionException {
        if ("application/xhtml+xml".equals(paramSourceMimeType)) {
            return this.convertHTMLToPDFInputStream(source);
        }
        if ("text/html".equals(paramSourceMimeType)) {
            return this.convertXHTMLToPDFInputStream(source);
        }
        return null;
    }

    private InputStream convertHTMLToPDFInputStream(InputStream paramSource) throws ConversionException {
        Document document;
        try {
            document = Jsoup.parse((InputStream)paramSource, (String)this.getConfiguredCharset(), (String)"");
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        String xhtmlString = document.html();
        ByteArrayInputStream bais = new ByteArrayInputStream(xhtmlString.getBytes());
        return this.convertXHTMLToPDFInputStream(bais);
    }

    private InputStream convertXHTMLToPDFInputStream(InputStream paramSource) throws ConversionException {
        String xhtmlString = null;
        try {
            xhtmlString = IOUtils.toString((InputStream)paramSource, (String)this.getConfiguredCharset());
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        ITextRenderer renderer = new ITextRenderer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        renderer.setDocumentFromString(xhtmlString);
        renderer.layout();
        renderer.createPDF((OutputStream)baos, false);
        renderer.finishPDF();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private String getConfiguredCharset() {
        String charsetConfigured = (String)this.configurationParameters.get("input.charset");
        if (charsetConfigured == null) {
            charsetConfigured = "utf-8";
        }
        return charsetConfigured;
    }

    public Future<List<InputStream>> convertFiles(List<File> source, String paramSourceMimeType, String paramTargetMimeType) throws ConversionException {
        try {
            ArrayList<InputStream> isList = new ArrayList<InputStream>();
            for (File sourceFile : source) {
                isList.add(new FileInputStream(sourceFile));
            }
            return this.convertStreams(isList, paramSourceMimeType, paramTargetMimeType);
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("File could not be read. Please check file!");
        }
    }

    public static boolean isInputTypeSupported(InputType paramInputType) {
        switch (paramInputType) {
            case FILE: {
                return true;
            }
            case INPUTSTREAM: {
                return true;
            }
        }
        return false;
    }
}

