/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.html2docx;

import de.elnarion.util.docconverter.api.exception.ConversionException;
import de.elnarion.util.docconverter.common.AbstractBaseConverter;
import de.elnarion.util.docconverter.spi.InputType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.RFonts;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HTML2DOCXConverter
extends AbstractBaseConverter {
    private static Map<String, Set<String>> supportedMimetypes = null;
    private static final Logger LOGGER = Logger.getLogger(HTML2DOCXConverter.class.getName());

    public HTML2DOCXConverter(Map<String, Object> paramConfigurationParameters) {
        super(paramConfigurationParameters);
    }

    public static synchronized Map<String, Set<String>> getSupportedConversion() {
        if (supportedMimetypes == null) {
            supportedMimetypes = new HashMap<String, Set<String>>();
            HashSet<String> targetMimetypes = new HashSet<String>();
            targetMimetypes.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            supportedMimetypes.put("text/html", targetMimetypes);
            supportedMimetypes.put("application/xhtml+xml", targetMimetypes);
        }
        return supportedMimetypes;
    }

    protected List<InputStream> convertToInputStream(InputStream source, String paramSourceMimeType) throws ConversionException {
        ArrayList<InputStream> resultStreams = new ArrayList<InputStream>();
        if ("application/xhtml+xml".equals(paramSourceMimeType)) {
            resultStreams.add(this.convertXHTMLToDocxInputStream(source));
        } else if ("text/html".equals(paramSourceMimeType)) {
            resultStreams.add(this.convertHTMLToDocxInputStream(source));
        }
        return resultStreams;
    }

    private InputStream convertHTMLToDocxInputStream(InputStream paramSource) throws ConversionException {
        Document document;
        try {
            document = Jsoup.parse((InputStream)paramSource, (String)this.getConfiguredCharset(), (String)"");
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        String xhtmlString = document.html();
        ByteArrayInputStream bais = new ByteArrayInputStream(xhtmlString.getBytes());
        return this.convertXHTMLToDocxInputStream(bais);
    }

    private InputStream convertXHTMLToDocxInputStream(InputStream paramSource) throws ConversionException {
        String xhtmlString = null;
        try {
            xhtmlString = IOUtils.toString((InputStream)paramSource, (String)this.getConfiguredCharset());
        }
        catch (IOException e) {
            throw new ConversionException("Conversion is not possible due to an IOException. Error message is " + e.getMessage(), (Throwable)e);
        }
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rfonts.setAscii("Century Gothic");
        XHTMLImporterImpl.addFontMapping((String)"Century Gothic", (RFonts)rfonts);
        try {
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
            NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
            wordMLPackage.getMainDocumentPart().addTargetPart((Part)ndp);
            ndp.unmarshalDefaultNumbering();
            XHTMLImporterImpl xhtmlImporter = new XHTMLImporterImpl(wordMLPackage);
            xhtmlImporter.setHyperlinkStyle("Hyperlink");
            if (this.getConfigurationParameters() != null && this.getConfigurationParameters().containsKey("input.basedirectory.url")) {
                wordMLPackage.getMainDocumentPart().getContent().addAll(xhtmlImporter.convert(xhtmlString, (String)this.getConfigurationParameters().get("input.basedirectory.url")));
            } else {
                String baseUrl = Paths.get("", new String[0]).toFile().toURI().toURL().toString();
                wordMLPackage.getMainDocumentPart().getContent().addAll(xhtmlImporter.convert(xhtmlString, baseUrl));
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(XmlUtils.marshaltoString((Object)wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            wordMLPackage.save((OutputStream)baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (MalformedURLException | JAXBException | Docx4JException e) {
            throw new ConversionException("Conversion is not possible due to an internal exception. Error message is " + e.getMessage(), e);
        }
    }

    public static boolean isInputTypeSupported(InputType paramInputType) {
        switch (paramInputType) {
            case FILE: {
                return true;
            }
            case INPUTSTREAM: {
                return true;
            }
        }
        return false;
    }
}

