/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.common;

import de.elnarion.util.docconverter.api.exception.ConversionException;
import de.elnarion.util.docconverter.spi.DocConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AbstractBaseConverter
implements DocConverter {
    private Map<String, Object> configurationParameters;

    protected AbstractBaseConverter(Map<String, Object> paramConfigurationParameters) {
        this.configurationParameters = paramConfigurationParameters;
    }

    public Future<List<InputStream>> convertStreams(final List<InputStream> source, final String paramSourceMimeType, String paramTargetMimeType) throws ConversionException {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        return exec.submit(new Callable<List<InputStream>>(){

            @Override
            public List<InputStream> call() throws Exception {
                ArrayList<InputStream> resultList = new ArrayList<InputStream>();
                for (InputStream is : source) {
                    resultList.addAll(AbstractBaseConverter.this.convertToInputStream(is, paramSourceMimeType));
                }
                return resultList;
            }
        });
    }

    public Future<List<InputStream>> convertFiles(List<File> source, String paramSourceMimeType, String paramTargetMimeType) throws ConversionException {
        try {
            ArrayList<InputStream> isList = new ArrayList<InputStream>();
            for (File sourceFile : source) {
                isList.add(new FileInputStream(sourceFile));
            }
            return this.convertStreams(isList, paramSourceMimeType, paramTargetMimeType);
        }
        catch (FileNotFoundException e) {
            throw new ConversionException("File could not be read. Please check file!");
        }
    }

    protected String getConfiguredCharset() {
        String charsetConfigured = (String)this.getConfigurationParameters().get("input.charset");
        if (charsetConfigured == null) {
            charsetConfigured = "utf-8";
        }
        return charsetConfigured;
    }

    protected Map<String, Object> getConfigurationParameters() {
        return this.configurationParameters;
    }

    protected abstract List<InputStream> convertToInputStream(InputStream var1, String var2) throws ConversionException;
}

