/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.docconverter.spi;

import de.elnarion.util.docconverter.spi.DocConverterManagerInterface;
import de.elnarion.util.docconverter.spi.DocConverterProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class DocConverterManager
implements DocConverterManagerInterface {
    private ServiceLoader<DocConverterProvider> docConverterServiceLoader;
    private Map<String, Map<DocConverterProvider, Set<String>>> docConverterProviderMap = new HashMap<String, Map<DocConverterProvider, Set<String>>>();

    private DocConverterManager(ClassLoader paramClassloader) {
        this.docConverterServiceLoader = paramClassloader != null ? ServiceLoader.load(DocConverterProvider.class, paramClassloader) : ServiceLoader.load(DocConverterProvider.class);
    }

    public static DocConverterManager getInstance() {
        return DocConverterManager.getInstance(null);
    }

    public static DocConverterManager getInstance(ClassLoader paramClassLoader) {
        DocConverterManager docConverterManager = new DocConverterManager(paramClassLoader);
        docConverterManager.reload();
        return docConverterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.docConverterServiceLoader.reload();
        HashMap<String, HashMap<DocConverterProvider, Set<String>>> currentDocConverterProviderMap = new HashMap<String, HashMap<DocConverterProvider, Set<String>>>();
        for (DocConverterProvider provider : this.docConverterServiceLoader) {
            Map<String, Set<String>> supportedMimetypesByDocProvider = provider.getSupportedMimeTypeConversions();
            if (supportedMimetypesByDocProvider == null) continue;
            Set<String> sourceMimeTypeSet = supportedMimetypesByDocProvider.keySet();
            for (String sourceMimeType : sourceMimeTypeSet) {
                HashMap<DocConverterProvider, Set<String>> providerTargetMapping = (HashMap<DocConverterProvider, Set<String>>)currentDocConverterProviderMap.get(sourceMimeType);
                if (providerTargetMapping == null) {
                    providerTargetMapping = new HashMap<DocConverterProvider, Set<String>>();
                    currentDocConverterProviderMap.put(sourceMimeType, providerTargetMapping);
                }
                providerTargetMapping.put(provider, supportedMimetypesByDocProvider.get(sourceMimeType));
            }
        }
        Map<String, Map<DocConverterProvider, Set<String>>> map = this.docConverterProviderMap;
        synchronized (map) {
            this.docConverterProviderMap.clear();
            this.docConverterProviderMap.putAll(currentDocConverterProviderMap);
        }
    }

    @Override
    public Map<String, Map<DocConverterProvider, Set<String>>> getDocConverterProviderMap() {
        return this.docConverterProviderMap;
    }

    @Override
    public Map<DocConverterProvider, Set<String>> getDocConverterProviderTargetMappingForSourceMimeType(String paramSourceMimeType) {
        if (paramSourceMimeType != null) {
            return this.docConverterProviderMap.get(paramSourceMimeType);
        }
        return null;
    }
}

