package de.elnarion.util.docconverter.api;

/**
 * The Class MimeTypeConstants.
 */
public class MimeTypeConstants {

	private MimeTypeConstants() {
	}

	/** The Constant APPLICATION_PDF. PDF-files (.pdf) */
	public static final String APPLICATION_PDF = "application/pdf";

	/** The Constant APPLICATION_EXCEL. MS Excel-files (.xls) */
	public static final String APPLICATION_EXCEL = "application/msexcel";

	/**
	 * The Constant APPLICATION_POWERPOINT. MS Powerpoint-files (*.ppt *.ppz *.pps
	 * *.pot)
	 */
	public static final String APPLICATION_POWERPOINT = "application/mspowerpoint";

	/** The Constant APPLICATION_WORD. MS Word-files (*.doc *.dot) */
	public static final String APPLICATION_WORD = "application/msword";

	/** The Constant APPLICATION_POSTSCRIPT. Postscript-files (*.ai *.eps *.ps) */
	public static final String APPLICATION_POSTSCRIPT = "application/postscript";

	/** The Constant APPLICATION_RTF. RTF-files (*.rtf) */
	public static final String APPLICATION_RTF = "application/rtf";

	/** The Constant APPLICATION_XLSX. *.xlsx Excel (OpenOffice Calc) */
	public static final String APPLICATION_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

	/** The Constant APPLICATION_DOCX. *.docx Word (OpenOffice Writer) */
	public static final String APPLICATION_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

	/** The Constant APPLICATION_XHTML. *.htm *.html *.shtml *.xhtml XHTML-files */
	public static final String APPLICATION_XHTML = "application/xhtml+xml";

	/** The Constant APPLICATION_XML. *.xml XML-files */
	public static final String APPLICATION_XML = "application/xml";

	/** The Constant APPLICATION_LATEX. *.latex LaTeX-Quelldateien */
	public static final String APPLICATION_LATEX = "application/x-latex";

	/** The Constant IMAGE_BMP. *.bmp Windows Bitmap-file */
	public static final String IMAGE_BMP = "image/bmp";

	/** The Constant IMAGE_GIF. *.gif GIF-files */
	public static final String IMAGE_GIF = "image/gif";

	/** The Constant IMAGE_JPEG. *.jpeg *.jpg *.jpe JPEG-files */
	public static final String IMAGE_JPEG = "image/jpeg";

	/** The Constant IMAGE_PNG. *.png PNG-files */
	public static final String IMAGE_PNG = "image/png";

	/** The Constant IMAGE_SVG. *.svg SVG-files */
	public static final String IMAGE_SVG = "image/svg+xml";

	/** The Constant IMAGE_TIFF. *.tiff *.tif TIFF-files */
	public static final String IMAGE_TIFF = "image/tiff";

	/** The Constant IMAGE_ICO. *.ico Icon-files (for example Favoriten-Icons) */
	public static final String IMAGE_ICO = "image/x-icon";

	/** The Constant TEXT_ASCIIDOC. *.adoc, *.ad, *.asciidoc ASCIIDOC-files */
	public static final String TEXT_ASCIIDOC = "text/x.asciidoc";

	/** The Constant TEXT_CSV. *.csv comma separated data file */
	public static final String TEXT_CSV = "text/comma-separated-values";

	/** The Constant TEXT_HTML. *.htm*.html*.shtml HTML-files */
	public static final String TEXT_HTML = "text/html";

	/** The Constant TEXT_PLAIN. *.txt pure text file */
	public static final String TEXT_PLAIN = "text/plain";

	/** The Constant TEXT_XML. *.xml XML-files */
	public static final String TEXT_XML = "text/xml";

}
