/*
 * Decompiled with CFR 0.152.
 */
package de.eleon.console.example;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.eleon.console.builder.ConsoleBuilder;
import de.eleon.console.builder.functional.Transformers;
import de.eleon.console.builder.functional.Validator;
import de.eleon.console.builder.functional.Validators;
import de.eleon.console.example.Person;
import java.io.IOException;
import java.util.Collection;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;

class Main {
    private Main() {
        String firstName = ConsoleBuilder.ask((String)"Please enter your first name").validateWith(Validators.notEmpty((String)"Empty String not allowed")).validateWith(Validators.regex((String)"[a-zA-Z0-9\\-]{2,}", (String)"Invalid format")).useHistory().answer();
        String lastName = ConsoleBuilder.ask((String)"Please enter your last name").validateWith(Validators.notEmpty((String)"Empty String not allowed")).validateWith(Validators.regex((String)"[a-zA-Z0-9\\-]{2,}", (String)"Invalid format")).useHistory().answer();
        Optional company = ConsoleBuilder.ask((String)"Please enter your company name").validateWith(Validators.regex((String)"[a-zA-Z0-9\\-]{2,}", (String)"Invalid format")).useHistory().optional().answer();
        Person.Gender gender = (Person.Gender)ConsoleBuilder.ask((String)"Please enter your gender").answer(Person.Gender.class, "Please enter valid gender");
        String favoriteColor = ConsoleBuilder.ask((String)"What ist your favorite color?").useHistoryFrom("color").answer();
        Integer age = (Integer)ConsoleBuilder.ask((String)"how old are you?").completeWith((Completer)new StringsCompleter(new String[]{"22", "33", "44", "55", "66"})).validateWith(this.validateAge("please enter valid age")).answer((Function)Transformers.toInteger());
        ConsoleBuilder.print((CharSequence)("First name " + firstName + ", last name " + lastName + ", company " + (String)company.or((Object)"-") + ", gender " + (Object)((Object)gender) + ", favoriteColor " + favoriteColor + ", age " + age));
        ConsoleBuilder.newline();
        ConsoleBuilder.newline();
        ConsoleBuilder.print((CharSequence)"Example creation of object with ");
        ConsoleBuilder.print((Collection)ImmutableList.of((Object)"name", (Object)"gender", (Object)"age"));
        ConsoleBuilder.print((CharSequence)"Create person");
        Person person = new Person(ConsoleBuilder.ask((String)"Please enter your first name").validateWith(Validators.notEmpty((String)"Empty String not allowed")).answer(), (Person.Gender)ConsoleBuilder.ask((String)"Please enter your gender").answer(Person.Gender.class, "Please enter valid gender"), (Integer)ConsoleBuilder.ask((String)"how old are you?").answer((Function)Transformers.toInteger()));
        ConsoleBuilder.print((CharSequence)("person: " + person));
    }

    private Validator validateAge(final String message) {
        return new Validator(){

            public boolean valid(String input) {
                Integer age = Integer.valueOf(input);
                return Range.closed((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(99)).contains((Comparable)age);
            }

            public String message() {
                return message;
            }
        };
    }

    public static void main(String[] args) throws IOException {
        new Main();
    }
}

