/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.inventory;

import de.eldoria.eldoutilities.inventory.ActionItem;
import de.eldoria.eldoutilities.utils.ObjUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class InventoryActions {
    private final Map<Integer, ActionItem> actions = new HashMap<Integer, ActionItem>();
    private final Inventory inventory;
    private final Consumer<InventoryCloseEvent> onClose;

    private InventoryActions(Inventory inventory, Consumer<InventoryCloseEvent> onClose) {
        this.inventory = inventory;
        this.onClose = onClose;
    }

    public static InventoryActions of(Inventory inventory) {
        return new InventoryActions(inventory, s -> {});
    }

    public static InventoryActions of(Inventory inventory, Consumer<InventoryCloseEvent> onClose) {
        return new InventoryActions(inventory, onClose);
    }

    public void addAction(ActionItem action) {
        this.inventory.setItem(action.getSlot(), action.getItemStack());
        this.actions.put(action.getSlot(), action);
    }

    public void addAction(ItemStack itemStack, int slot, Consumer<InventoryClickEvent> onClick, Consumer<@Nullable ItemStack> onClose) {
        this.addAction(new ActionItem(itemStack, slot, onClick, onClose));
    }

    public void onInventoryClose(InventoryCloseEvent event) {
        for (Map.Entry<Integer, ActionItem> entry : this.actions.entrySet()) {
            entry.getValue().onInventoryClose(this.inventory.getItem(entry.getKey().intValue()));
        }
        this.onClose.accept(event);
    }

    public void onInventoryClick(InventoryClickEvent event) {
        ObjUtil.nonNull((Object)this.actions.get(event.getSlot()), s -> s.onInventoryClick(event));
    }
}

