/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public record Version(String version, List<Integer> nums) implements Comparable<Version>
{
    private final List<Integer> nums;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int PATCH = 2;
    private static final Pattern NUMBER = Pattern.compile("([0-9]+)");

    public static Version parse(String version) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        Matcher matcher = NUMBER.matcher(version);
        while (matcher.find()) {
            nums.add(Integer.parseInt(matcher.group(1)));
        }
        return new Version(version, nums);
    }

    public static Version of(Integer ... nums) {
        return Version.of(Arrays.stream(nums).toList());
    }

    public static Version of(List<Integer> nums) {
        return new Version(nums.stream().map(String::valueOf).collect(Collectors.joining(".")), nums);
    }

    public List<Integer> nums() {
        return Collections.unmodifiableList(this.nums);
    }

    public boolean isOlder(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isOlderOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isNewer(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isNewerOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isEqual(Version version) {
        return this.compareTo(version) == 0;
    }

    public boolean isBetweenInclusive(Version lower, Version upper) {
        return this.isNewer(lower) && this.isOlder(upper);
    }

    public boolean isBetween(Version lower, Version upper) {
        return this.isNewerOrEqual(lower) && this.isOlder(upper);
    }

    public Comparator<String> comparator() {
        return Comparator.comparing(Version::parse);
    }

    public Version trim(int num) {
        return Version.of((Integer[])this.nums.subList(0, Math.min(this.nums.size(), num)).toArray(Integer[]::new));
    }

    public Version set(int index, int value) {
        ArrayList<Integer> newNums = new ArrayList<Integer>(this.nums);
        if (newNums.size() < index) {
            newNums.set(index, value);
        } else {
            newNums.add(value);
        }
        return Version.of(newNums);
    }

    public Version increase(int index, int value) {
        ArrayList<Integer> newNums = new ArrayList<Integer>(this.nums);
        newNums.set(index, newNums.get(index) + value);
        return Version.of(newNums);
    }

    public Version decrease(int index, int value) {
        ArrayList<Integer> newNums = new ArrayList<Integer>(this.nums);
        newNums.set(index, Math.max(newNums.get(index) - value, 0));
        return Version.of(newNums);
    }

    @Override
    public String toString() {
        return this.version;
    }

    public int size() {
        return this.nums.size();
    }

    @Override
    public int compareTo(@NotNull Version version) {
        int numbers = Math.max(version.nums().size(), this.nums().size());
        for (int i = 0; i < numbers; ++i) {
            int compare = Integer.compare(this.nums().size() > i ? this.nums().get(i) : 0, version.nums().size() > i ? version.nums().get(i) : 0);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

