/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;

public final class TextFormatting {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm dd.MM.yyyy");

    private TextFormatting() {
    }

    public static String fillString(String string, int fill) {
        if (string.length() >= fill) {
            return string;
        }
        int charsToFill = fill - string.length();
        StringBuilder builder = new StringBuilder(string);
        builder.append(" ".repeat(charsToFill));
        return builder.toString();
    }

    public static String getRangeAsString(String delimiter, String[] source, int from, int to) {
        int finalTo = to;
        if (to < 1) {
            finalTo = source.length + to;
        }
        int finalFrom = from;
        if (from < 0) {
            finalFrom = source.length + from;
        }
        if (finalFrom > finalTo || finalFrom < 0 || finalTo > source.length) {
            return "";
        }
        return String.join((CharSequence)delimiter, Arrays.copyOfRange(source, finalFrom, finalTo)).trim();
    }

    public static String cropText(String string, String endSequence, int maxChars, boolean keepWords) {
        if (string.length() <= maxChars) {
            return string;
        }
        if (!keepWords) {
            String substring = string.substring(0, Math.max(0, maxChars - endSequence.length()));
            return (substring + endSequence).trim();
        }
        String[] split = string.split("\\s");
        StringBuilder builder = new StringBuilder();
        for (String s : split) {
            if (builder.length() + s.length() + 1 + endSequence.length() > maxChars) {
                return builder.toString().trim() + endSequence;
            }
            builder.append(s).append(" ");
        }
        return builder.toString().trim();
    }

    public static String mapBooleanTo(boolean bool, String trueTo, String falseTo) {
        return bool ? trueTo : falseTo;
    }

    public static String getTimeAsString() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }
}

