/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import java.util.Optional;
import java.util.OptionalInt;

public final class Parser {
    private Parser() {
        throw new UnsupportedOperationException("This is a utility class!");
    }

    public static Optional<Integer> parseInt(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> parseDouble(String s) {
        try {
            return Optional.of(Double.parseDouble(s.replace(",", ".")));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Boolean> parseBoolean(String s) {
        return Parser.parseBoolean(s, "true", "false");
    }

    public static Optional<Boolean> parseBoolean(String s, String trueValue, String falseValue) {
        if (s.equalsIgnoreCase(trueValue)) {
            return Optional.of(true);
        }
        if (s.equalsIgnoreCase(falseValue)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static OptionalInt parseTimeToTicks(String s) {
        String[] split = s.split(":");
        if (split.length != 2) {
            return OptionalInt.empty();
        }
        Optional<Integer> hour = Parser.parseInt(split[0]);
        Optional<Integer> min = Parser.parseInt(split[1]);
        if (!hour.isPresent() || !min.isPresent()) {
            return OptionalInt.empty();
        }
        int hourTicks = (hour.get() - 6) * 1000 % 24000;
        if (hourTicks < 0) {
            hourTicks = 24000 + hourTicks;
        }
        int minTicks = (int)Math.floor(16.666666666666668 * (double)min.get().intValue());
        return OptionalInt.of(hourTicks + minTicks);
    }

    public static String parseTicksToTime(long ticks) {
        long time = ticks % 24000L;
        int hours = ((int)Math.floor((double)time / 1000.0) + 6) % 24;
        int min = (int)Math.floor((double)(time % 1000L + 1L) / 16.666666666666668);
        if (min < 10) {
            return hours + ":0" + min;
        }
        return hours + ":" + min;
    }

    public static <T> Optional<Long> parseLong(String value) {
        try {
            return Optional.of(Long.parseLong(value.replace(",", ".")));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

