/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    @Deprecated
    public static void setAttributeValue(AttributeInstance attribute, double target) throws NullPointerException {
        attribute.setBaseValue(target / (attribute.getValue() / Math.max(attribute.getBaseValue(), 1.0)));
    }

    public static void setAttributeValue(@NotNull LivingEntity entity, @NotNull Attribute attribute, @NotNull double target) {
        AttributeInstance a = entity.getAttribute(attribute);
        if (a == null) {
            Bukkit.getLogger().log(Level.WARNING, "[EldoUtilities] Attempted to set attribute " + attribute + " for " + entity.getType() + ", but Attribute is not present on this type.", new IllegalArgumentException("A not present attribute was requested to change"));
            return;
        }
        AttributeUtil.setAttributeValue(a, target);
    }

    public static void syncAttributeValue(LivingEntity source, LivingEntity target, Attribute attribute) {
        AttributeInstance sourceAttribute = source.getAttribute(attribute);
        AttributeInstance targetAttribute = target.getAttribute(attribute);
        if (sourceAttribute == null) {
            Bukkit.getLogger().log(Level.WARNING, "Attempted to sync attribute " + attribute + " between source " + source.getType() + " and target " + target.getType() + ", but Attribute is not present on source", new IllegalArgumentException("A not present attribute was requested to change"));
            return;
        }
        if (targetAttribute == null) {
            Bukkit.getLogger().log(Level.WARNING, "Attempted to sync attribute " + attribute + " between source " + source.getType() + " and target " + target.getType() + ", but Attribute is not present on target", new IllegalArgumentException("A not present attribute was requested to change"));
            return;
        }
        AttributeUtil.setAttributeValue(target, attribute, sourceAttribute.getValue());
        if (attribute == Attribute.GENERIC_MAX_HEALTH) {
            target.setHealth(targetAttribute.getValue());
        }
    }

    public static double getAttributeValue(LivingEntity entity, Attribute attribute) {
        AttributeInstance entityAttribute = entity.getAttribute(attribute);
        if (entityAttribute == null) {
            return 0.0;
        }
        return entityAttribute.getValue();
    }
}

