/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class ArrayUtil {
    private ArrayUtil() {
        throw new UnsupportedOperationException("This is a utility class!");
    }

    public static Matcher findInArray(String[] strings, Pattern contains) {
        for (String string : strings) {
            Matcher matcher = contains.matcher(string);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    public static boolean arrayContains(String[] strings, String ... values) {
        for (String string : strings) {
            for (String contain : values) {
                if (!string.equalsIgnoreCase(contain)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean arrayContains(char[] chars, char ... values) {
        for (char character : chars) {
            for (char contain : values) {
                if (character != contain) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] combineArrays(String[] array, String[] ... arrays) {
        Object[] result = array;
        for (Object[] objectArray : arrays) {
            result = (String[])ObjectArrays.concat((Object[])objectArray, (Object[])result, String.class);
        }
        return result;
    }

    @SafeVarargs
    public static <T> T[] combineArrays(Class<T> clazz, T[] array, T[] ... arrays) {
        Object[] result = array;
        for (Object[] objectArray : arrays) {
            result = ObjectArrays.concat((Object[])objectArray, (Object[])result, clazz);
        }
        return result;
    }

    public static Stream<String> startingWithInArray(String value, String[] array) {
        return Arrays.stream(array).filter(e -> e.toLowerCase().startsWith(value.toLowerCase()));
    }

    public static boolean stringStartingWithValueInArray(String value, String[] array) {
        return Arrays.stream(array).anyMatch(value::startsWith);
    }

    public static boolean endingWithInArray(String value, String[] array) {
        return Arrays.stream(array).anyMatch(value::endsWith);
    }
}

