/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import de.eldoria.eldoutilities.utils.TextFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ArgumentUtils {
    private static final String SPACE_REPLACE = ":";

    private ArgumentUtils() {
        throw new UnsupportedOperationException("This is a utility class!");
    }

    public static String getOrDefault(String[] arguments, int index, String defaultValue) {
        String arg = ArgumentUtils.get(arguments, index);
        return arg == null ? defaultValue : arg;
    }

    public static <T> T getOrDefault(String[] arguments, int index, Function<String, T> parse, T defaultValue) {
        String s = ArgumentUtils.get(arguments, index);
        if (s == null) {
            return defaultValue;
        }
        return parse.apply(s);
    }

    public static String get(String[] arguments, int index) {
        if (arguments.length > index) {
            return arguments[index];
        }
        return null;
    }

    public static <T> Optional<T> get(String[] arguments, int index, Function<String, T> parse) {
        if (arguments.length > index) {
            parse.apply(arguments[index]);
        }
        return Optional.empty();
    }

    public static <T> T getOptionalParameter(String[] arguments, int index, T defaultValue, Function<String, T> parse) {
        String arg = ArgumentUtils.get(arguments, index);
        if (arg == null) {
            return defaultValue;
        }
        return parse.apply(arg);
    }

    public static <T> T getDefaultFromPlayerOrArg(String[] args, int index, CommandSender sender, Function<Player, T> playerFunction, Function<String, T> argFunction) {
        T result = null;
        if (sender instanceof Player) {
            result = playerFunction.apply((Player)sender);
        }
        if (args.length > index) {
            result = argFunction.apply(args[index]);
        }
        return result;
    }

    public static String getRangeAsString(String delimiter, String[] source, int from, int to) {
        int finalTo = to;
        if (to < 1) {
            finalTo = source.length + to;
        }
        int finalFrom = from;
        if (from < 0) {
            finalFrom = source.length + from;
        }
        if (finalFrom > finalTo || finalFrom < 0 || finalTo > source.length) {
            return "";
        }
        return String.join((CharSequence)delimiter, Arrays.copyOfRange(source, finalFrom, finalTo)).trim();
    }

    public static String getRangeAsString(String[] strings, int from) {
        return ArgumentUtils.getRangeAsString(" ", strings, from, 0);
    }

    public static String unescapeWorldName(String world) {
        return ArgumentUtils.unescapeWorldName(world, SPACE_REPLACE);
    }

    public static String unescapeWorldName(String world, String replace) {
        return world.replace(replace, " ");
    }

    public static String escapeWorldName(String world) {
        return ArgumentUtils.escapeWorldName(world, SPACE_REPLACE);
    }

    public static String escapeWorldName(String world, String replace) {
        return world.replace(" ", replace);
    }

    public static String escapeWorldName(World world) {
        return ArgumentUtils.escapeWorldName(world, SPACE_REPLACE);
    }

    public static String escapeWorldName(World world, String replace) {
        return ArgumentUtils.escapeWorldName(world.getName(), replace);
    }

    public static World getWorld(String world) {
        return Bukkit.getWorld((String)ArgumentUtils.unescapeWorldName(world));
    }

    public static String[] parseQuotedArgs(String args, boolean strip) {
        if (strip) {
            args = args.replace("\\s+", " ");
        }
        return ArgumentUtils.parseQuotedArgs(args.split("\\s"));
    }

    public static String[] parseQuotedArgs(String[] args) {
        ArrayList<String> currArgs = new ArrayList<String>();
        ArrayList<String> currArg = new ArrayList<String>();
        boolean open = false;
        for (String arg : args) {
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                currArgs.add(arg.replace("\"", ""));
                continue;
            }
            if (arg.startsWith("\"")) {
                open = true;
            }
            if (!open) {
                currArgs.add(arg);
                continue;
            }
            if (arg.endsWith("\"")) {
                currArg.add(arg);
                currArgs.add(String.join((CharSequence)" ", currArg).replace("\"", ""));
                currArg.clear();
                open = false;
                continue;
            }
            currArg.add(arg);
        }
        return currArgs.toArray(new String[0]);
    }

    public static String getMessage(String[] strings, int from) {
        return ArgumentUtils.getMessage(strings, from, 0);
    }

    public static String getMessage(List<String> strings, int from) {
        return ArgumentUtils.getMessage(strings.toArray(new String[0]), from, 0);
    }

    public static String getMessage(String[] strings, int from, int to) {
        return TextFormatting.getRangeAsString(" ", strings, from, to);
    }

    public static String getMessage(List<String> strings, int from, int to) {
        return TextFormatting.getRangeAsString(" ", strings.toArray(new String[0]), from, to);
    }

    public static <T> List<T> getRangeAsList(T[] objects, int from) {
        return ArgumentUtils.getRangeAsList(objects, from, 0);
    }

    public static <T> List<T> getRangeAsList(T[] objects, int from, int to) {
        return ArgumentUtils.getRangeAsList(Arrays.asList(objects), from, to);
    }

    public static <T> List<T> getRangeAsList(List<T> objects, int from) {
        return ArgumentUtils.getRangeAsList(objects, from, 0);
    }

    public static <T> List<T> getRangeAsList(List<T> objects, int from, int to) {
        int finalTo = to;
        if (to < 1) {
            finalTo = objects.size() + to;
        }
        int finalFrom = from;
        if (from < 0) {
            finalFrom = objects.size() + from;
        }
        if (finalFrom > finalTo || finalFrom < 0 || finalTo > objects.size()) {
            return Collections.emptyList();
        }
        return objects.subList(finalFrom, finalTo);
    }
}

