/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.pdc;

import de.eldoria.eldoutilities.pdc.DataContainerUtil;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class PersistentDataWrapper {
    private final PersistentDataContainer container;

    public PersistentDataWrapper(PersistentDataContainer container) {
        this.container = container;
    }

    public static PersistentDataWrapper create(PersistentDataHolder holder) {
        return new PersistentDataWrapper(holder.getPersistentDataContainer());
    }

    public <T, Z> void setIfAbsent(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        DataContainerUtil.setIfAbsent(this.container, key, type, value);
    }

    @Nullable
    public <T, Z> Z compute(NamespacedKey key, PersistentDataType<T, Z> type, Function<@Nullable Z, Z> map) {
        return DataContainerUtil.compute(this.container, key, type, map);
    }

    @Nullable
    public <T, Z> Z computeIfAbsent(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        return DataContainerUtil.computeIfAbsent(this.container, key, type, value);
    }

    @Nullable
    public <T, Z> Z computeIfPresent(NamespacedKey key, PersistentDataType<T, Z> type, Function<Z, Z> mappingFunction) {
        return DataContainerUtil.computeIfPresent(this.container, key, type, mappingFunction);
    }

    public <T, Z> Optional<Z> get(NamespacedKey key, PersistentDataType<T, Z> type) {
        return DataContainerUtil.get(this.container, key, type);
    }

    public <T, Z> Z getOrDefault(NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        return DataContainerUtil.getOrDefault(this.container, key, type, defaultValue);
    }

    public <T, Z> void put(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        DataContainerUtil.putValue(this.container, key, type, value);
    }

    public <T, Z> boolean hasKey(NamespacedKey key, PersistentDataType<T, Z> type) {
        return DataContainerUtil.get(this.container, key, type).isPresent();
    }

    public <T, Z> boolean remove(NamespacedKey key, PersistentDataType<T, Z> type) {
        return DataContainerUtil.remove(this.container, key, type);
    }
}

