/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.pdc;

import java.util.Optional;
import java.util.function.Function;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class DataContainerUtil {
    private DataContainerUtil() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    public static <T, Z> void setIfAbsent(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (container.has(key, type)) {
            return;
        }
        container.set(key, type, value);
    }

    public static <T, Z> void setIfAbsent(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return;
        }
        PersistentDataContainer container = holder.getPersistentDataContainer();
        DataContainerUtil.setIfAbsent(container, key, type, value);
    }

    public static <T, Z> void setIfAbsent(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        DataContainerUtil.setIfAbsent((PersistentDataHolder)itemMeta, key, type, value);
        holder.setItemMeta(itemMeta);
    }

    @Nullable
    public static <T, Z> Z compute(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Function<@Nullable Z, Z> map) {
        if (!container.has(key, type)) {
            container.set(key, type, map.apply(null));
            return (Z)container.get(key, type);
        }
        container.set(key, type, map.apply(container.get(key, type)));
        return (Z)container.get(key, type);
    }

    @Nullable
    public static <T, Z> Z compute(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Function<@Nullable Z, Z> map) {
        if (holder == null) {
            return null;
        }
        PersistentDataContainer container = holder.getPersistentDataContainer();
        return DataContainerUtil.compute(container, key, type, map);
    }

    @Nullable
    public static <T, Z> Z compute(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Function<Z, Z> map) {
        if (holder == null) {
            return null;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        Z compute = DataContainerUtil.compute((PersistentDataHolder)itemMeta, key, type, map);
        holder.setItemMeta(itemMeta);
        return compute;
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfAbsent(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        return (Z)DataContainerUtil.compute(container, key, type, (Z v) -> {
            if (v == null) {
                return value;
            }
            return v;
        });
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfAbsent(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return null;
        }
        return (Z)DataContainerUtil.compute(holder, key, type, (Z v) -> {
            if (v == null) {
                return value;
            }
            return v;
        });
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfAbsent(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return null;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        Z z = DataContainerUtil.computeIfAbsent((PersistentDataHolder)itemMeta, key, type, value);
        holder.setItemMeta(itemMeta);
        return z;
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfPresent(@Nullable PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Function<Z, Z> mappingFunction) {
        if (container == null) {
            return null;
        }
        return (Z)DataContainerUtil.compute(container, key, type, (Z v) -> {
            if (v != null) {
                return mappingFunction.apply(v);
            }
            return null;
        });
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfPresent(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Function<Z, Z> mappingFunction) {
        if (holder == null) {
            return null;
        }
        return (Z)DataContainerUtil.compute(holder, key, type, (Z v) -> {
            if (v != null) {
                return mappingFunction.apply(v);
            }
            return null;
        });
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _, -> !null")
    @Nullable
    public static <T, Z> Z computeIfPresent(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Function<Z, Z> mappingFunction) {
        if (holder == null) {
            return null;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        Z z = DataContainerUtil.computeIfPresent((PersistentDataHolder)itemMeta, key, type, mappingFunction);
        holder.setItemMeta(itemMeta);
        return z;
    }

    public static <T, Z> Optional<Z> get(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (container.has(key, type)) {
            return Optional.ofNullable(container.get(key, type));
        }
        return Optional.empty();
    }

    public static <T, Z> Optional<Z> get(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return Optional.empty();
        }
        return DataContainerUtil.get(holder.getPersistentDataContainer(), key, type);
    }

    public static <T, Z> Optional<Z> get(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return Optional.empty();
        }
        return DataContainerUtil.get((PersistentDataHolder)holder.getItemMeta(), key, type);
    }

    public static <T, Z> Z getOrDefault(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        return DataContainerUtil.get(container, key, type).orElse(defaultValue);
    }

    public static <T, Z> Z getOrDefault(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        return DataContainerUtil.get(holder, key, type).orElse(defaultValue);
    }

    public static <T, Z> Z getOrDefault(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        if (holder == null) {
            return defaultValue;
        }
        return DataContainerUtil.getOrDefault((PersistentDataHolder)holder.getItemMeta(), key, type, defaultValue);
    }

    public static <T, Z> void putValue(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        DataContainerUtil.compute(container, key, type, (Z v) -> value);
    }

    public static <T, Z> void putValue(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return;
        }
        DataContainerUtil.compute(holder, key, type, (Z v) -> value);
    }

    public static <T, Z> void putValue(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (holder == null) {
            return;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        DataContainerUtil.putValue((PersistentDataHolder)itemMeta, key, type, value);
        holder.setItemMeta(itemMeta);
    }

    public static <T, Z> boolean hasKey(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type) {
        return DataContainerUtil.get(container, key, type).isPresent();
    }

    public static <T, Z> boolean hasKey(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return false;
        }
        return DataContainerUtil.get(holder, key, type).isPresent();
    }

    public static <T, Z> boolean hasKey(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return false;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        return DataContainerUtil.hasKey((PersistentDataHolder)itemMeta, key, type);
    }

    public static <T, Z> boolean remove(PersistentDataContainer container, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (container.has(key, type)) {
            container.remove(key);
            return true;
        }
        return DataContainerUtil.get(container, key, type).isPresent();
    }

    public static <T, Z> boolean remove(@Nullable PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return false;
        }
        return DataContainerUtil.remove(holder.getPersistentDataContainer(), key, type);
    }

    public static <T, Z> boolean remove(@Nullable ItemStack holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        if (holder == null) {
            return false;
        }
        ItemMeta itemMeta = holder.getItemMeta();
        if (DataContainerUtil.remove((PersistentDataHolder)itemMeta, key, type)) {
            holder.setItemMeta(itemMeta);
            return true;
        }
        return false;
    }

    public static boolean byteToBoolean(Byte aByte) {
        return aByte != null && aByte == 1;
    }

    public static byte booleanToByte(boolean aBoolean) {
        return (byte)(aBoolean ? 1 : 0);
    }
}

