/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.localization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public interface ILocalizer {
    public static final Map<Class<? extends Plugin>, ILocalizer> LOCALIZER = new HashMap<Class<? extends Plugin>, ILocalizer>();
    public static final ILocalizer DEFAULT = new DummyLocalizer();
    public static final Pattern LOCALIZATION_CODE = Pattern.compile("([a-zA-Z0-9_\\-.]+?)\\.([a-zA-Z0-9_\\-.]+)");

    public static ILocalizer getPluginLocalizer(Plugin plugin) {
        if (plugin == null) {
            return DEFAULT;
        }
        return ILocalizer.getPluginLocalizer(plugin.getClass());
    }

    public static ILocalizer getPluginLocalizer(Class<? extends Plugin> plugin) {
        if (plugin == null) {
            return DEFAULT;
        }
        return LOCALIZER.getOrDefault(plugin, DEFAULT);
    }

    public Plugin plugin();

    public static String escape(String propertyKey) {
        return String.format("<i18n:%s>", propertyKey);
    }

    public static boolean isLocaleCode(String message) {
        return LOCALIZATION_CODE.matcher(message).matches();
    }

    public void setLocale(String var1);

    public String getMessage(String var1);

    public String[] getIncludedLocales();

    public Set<String> includedLocales();

    public void addLocaleCodes(Map<String, String> var1);

    public String getMessage(String var1, CommandSender var2);

    @Nullable
    public String getValue(String var1);

    public String getMessage(String var1, String var2);

    @Nullable
    public String getValue(String var1, CommandSender var2);

    @Nullable
    public String getValue(String var1, String var2);

    public ResourceBundle localeBundle(String var1);

    public ResourceBundle defaultBundle();

    default public String localize(String message) {
        return this.localize(null, message);
    }

    public String localize(CommandSender var1, String var2);

    public void registerChild(ILocalizer var1);

    public static class DummyLocalizer
    implements ILocalizer {
        @Override
        public Plugin plugin() {
            return null;
        }

        @Override
        public void setLocale(String language) {
        }

        @Override
        public String getMessage(String key) {
            return key;
        }

        @Override
        public String[] getIncludedLocales() {
            return new String[0];
        }

        @Override
        public Set<String> includedLocales() {
            return Collections.emptySet();
        }

        @Override
        public void addLocaleCodes(Map<String, String> runtimeLocaleCodes) {
        }

        @Override
        public String getMessage(String key, CommandSender sender) {
            return key;
        }

        @Override
        @Nullable
        public String getValue(String key) {
            return key;
        }

        @Override
        public String getMessage(String key, String language) {
            return key;
        }

        @Override
        @Nullable
        public String getValue(String key, CommandSender sender) {
            return key;
        }

        @Override
        @Nullable
        public String getValue(String key, String language) {
            return key;
        }

        @Override
        public ResourceBundle localeBundle(String language) {
            return null;
        }

        @Override
        public ResourceBundle defaultBundle() {
            return null;
        }

        @Override
        public String localize(CommandSender sender, String message) {
            return message;
        }

        @Override
        public void registerChild(ILocalizer localizer) {
        }
    }
}

