/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.debug;

import com.google.common.hash.Hashing;
import de.eldoria.eldoutilities.debug.DefaultProperties;
import de.eldoria.eldoutilities.utils.Plugins;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public final class UserData {
    public final String type;
    public final String user = "%%__USER__%%";
    public final String resource = "%%__RESOURCE__%%";
    public final String nonce = "%%__NONCE__%%";
    private final Map<String, String> buildProperties;

    private UserData(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
        this.type = buildProperties.getOrDefault("type", "LOCAL");
    }

    public static UserData get(Plugin plugin) {
        Map<String, String> buildProperties = new LinkedHashMap<String, String>();
        try (InputStream in = plugin.getResource("build.data");){
            if (in != null) {
                buildProperties = Arrays.stream(new String(in.readAllBytes(), StandardCharsets.UTF_8).split("\n")).filter(r -> !r.isBlank()).map(e -> e.split("=", 2)).filter(e -> ((String[])e).length == 2).collect(Collectors.toMap(e -> e[0], e -> e[1]));
            }
            Path pluginFile = Plugins.getPluginFile(plugin).get().toPath();
            String md5 = Hashing.md5().hashBytes(Files.readAllBytes(pluginFile)).toString();
            String sha256 = Hashing.sha256().hashBytes(Files.readAllBytes(pluginFile)).toString();
            buildProperties.put("md5", md5);
            buildProperties.put("sha256", sha256);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new UserData(buildProperties);
    }

    public Optional<String> property(String property) {
        return Optional.ofNullable(this.buildProperties.get(property));
    }

    public Optional<String> property(DefaultProperties property) {
        return this.property(property.key());
    }

    public String resource() {
        return "%%__RESOURCE__%%";
    }

    public boolean isPremium() {
        return "PUBLIC".equalsIgnoreCase(this.type);
    }

    public String user() {
        return "%%__USER__%%";
    }

    public String asString() {
        ArrayList<Object> properties = new ArrayList<Object>();
        properties.add("Premium: " + this.isPremium());
        properties.add("User: " + this.user());
        properties.add("Nonce: %%__NONCE__%%");
        this.buildProperties.entrySet().stream().map(e -> "%s: %s".formatted(e.getKey(), e.getValue())).forEach(properties::add);
        return String.join((CharSequence)"\n", properties);
    }
}

