/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class EldoUtilities {
    private static Plugin mainOwner;
    private static Map<Class<? extends Plugin>, Plugin> instanceOwners;
    private static YamlConfiguration configuration;

    private EldoUtilities() {
    }

    public static Logger logger() {
        return Bukkit.getLogger();
    }

    public static void preWarm(Plugin eldoPlugin) {
        instanceOwners.put(eldoPlugin.getClass(), eldoPlugin);
    }

    public static void ignite(Plugin plugin) {
        Path path = plugin.getDataFolder().toPath().toAbsolutePath().getParent().resolve(Paths.get("EldoUtilities", "config.yml"));
        configuration = YamlConfiguration.loadConfiguration((File)path.toFile());
    }

    public static void shutdown() {
    }

    public static YamlConfiguration getConfiguration() {
        if (configuration == null) {
            Path config = Bukkit.getUpdateFolderFile().toPath().toAbsolutePath().getParent().resolve(Paths.get("EldoUtilities", "config.yml"));
            configuration = YamlConfiguration.loadConfiguration((File)config.toFile());
        }
        return configuration;
    }

    public static Plugin getInstanceOwner(Class<? extends Plugin> plugin) {
        return instanceOwners.get(plugin);
    }

    public static void forceInstanceOwner(Plugin plugin) {
        if (mainOwner != null) {
            throw new IllegalStateException("A instance owner is already set");
        }
        mainOwner = plugin;
    }

    public static Plugin getInstanceOwner() {
        if (mainOwner != null) {
            return mainOwner;
        }
        Iterator<Map.Entry<Class<? extends Plugin>, Plugin>> iterator = instanceOwners.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Class<? extends Plugin>, Plugin> entry = iterator.next();
            return entry.getValue();
        }
        throw new IllegalStateException("No instance owner is set but requested");
    }

    static {
        instanceOwners = new LinkedHashMap<Class<? extends Plugin>, Plugin>();
    }
}

