/*
 * Copyright 2016-2022  Christoph Brill &lt;opensource@christophbrill.de&gt;
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package libldt3.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import libldt3.LdtReader;
import libldt3.LdtWriter;

/**
 * Annotation zur Definition eines Feldes. Der {@link LdtReader} liest die Daten
 * automatisch in die annotierten Felder, der {@link LdtWriter} schreibt
 * ausschließlich die annotierten Felder.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Feld {

    /**
     * @return FK der Spezifikation (z.B. "7331" für Mobiltelefonnummer)
     */
    String value();

    /**
     * @return gibt an, ob es sich um ein Pflichtfeld handelt
     */
    Feldart feldart();

    /**
     * @return Name des Objektes im LDT (notwendig für das Schreiben von LDT
     *         durch den {@link LdtWriter})
     */
    String name() default "";

}
