/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import libldt3.annotations.Feld;
import libldt3.annotations.Objekt;
import libldt3.model.Kontext;
import libldt3.model.objekte.Fliesstext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KontextregelHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KontextregelHelper.class);

    KontextregelHelper() {
    }

    public static boolean containsAnyValue(Field field, Object owner) throws IllegalAccessException {
        Object value = KontextregelHelper.getFieldValue(field, owner);
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return KontextregelHelper.containsAnyString((String)value);
        }
        if (value instanceof Fliesstext) {
            return KontextregelHelper.containsAnyString((Fliesstext)value);
        }
        return true;
    }

    public static Object getFieldValue(Field field, Object owner) throws IllegalAccessException {
        if (field == null) {
            LOG.warn("No field given, cannot check for content");
            return null;
        }
        field.setAccessible(true);
        return field.get(owner);
    }

    public static boolean containsAnyString(String value) throws IllegalAccessException {
        return !value.isEmpty();
    }

    public static boolean containsAnyString(Fliesstext value) throws IllegalAccessException {
        Fliesstext fliesstext = value;
        if (fliesstext.text != null) {
            for (String s : fliesstext.text) {
                if (s == null || s.isEmpty()) continue;
                return true;
            }
        }
        if (fliesstext.base64kodierteAnlage != null) {
            for (String s : fliesstext.base64kodierteAnlage) {
                if (s == null || s.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static Field findField(Object owner, String fieldtype) {
        for (Field f : owner.getClass().getDeclaredFields()) {
            Feld annotation = f.getAnnotation(Feld.class);
            if (annotation == null || !annotation.value().equals(fieldtype)) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    public static Map<String, Field> findFields(Kontext owner, Set<String> fieldtypes) {
        HashMap<String, Field> result = new HashMap<String, Field>(fieldtypes.size());
        for (Field f : owner.getClass().getDeclaredFields()) {
            Feld annotation = f.getAnnotation(Feld.class);
            if (annotation == null || !fieldtypes.contains(annotation.value())) continue;
            f.setAccessible(true);
            result.put(annotation.value(), f);
        }
        return result;
    }

    public static Map<Kontext, Map<String, Field>> findFieldsRecursive(Kontext owner, Set<String> fieldtypes) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Kontext, Map<String, Field>> result = new HashMap<Kontext, Map<String, Field>>();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        result.put(owner, fields);
        for (Field f : owner.getClass().getDeclaredFields()) {
            Feld annotation = f.getAnnotation(Feld.class);
            if (annotation != null && fieldtypes.contains(annotation.value())) {
                f.setAccessible(true);
                fields.put(annotation.value(), f);
            }
            f.setAccessible(true);
            Object obj = f.get(owner);
            if (obj == null) continue;
            if (obj.getClass().getAnnotation(Objekt.class) != null) {
                result.putAll(KontextregelHelper.findFieldsRecursive((Kontext)obj, fieldtypes));
                continue;
            }
            if (!(obj instanceof Iterable)) continue;
            for (Object o : (Iterable)obj) {
                if (o.getClass().getAnnotation(Objekt.class) == null) continue;
                result.putAll(KontextregelHelper.findFieldsRecursive((Kontext)o, fieldtypes));
            }
        }
        return result;
    }
}

