/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Beauftragungsgrund;
import libldt3.model.enums.TestungRechtsgrundlage;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K131
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K131.class);
    private static final Set<String> FIELDTYPES = Set.of("8626", "8627", "8617");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        TestungRechtsgrundlage feld8626 = (TestungRechtsgrundlage)((Object)fields.get("8626").get(owner));
        String feld8627 = (String)fields.get("8627").get(owner);
        Beauftragungsgrund feld8617 = (Beauftragungsgrund)((Object)fields.get("8617").get(owner));
        if (feld8626 == TestungRechtsgrundlage.RegionaleSondervereinbarung && !KontextregelHelper.containsAnyValue(fields.get("8627"), owner) && !KontextregelHelper.containsAnyValue(fields.get("4111"), owner)) {
            return false;
        }
        if ((feld8626 == TestungRechtsgrundlage.TestV || feld8626 == TestungRechtsgrundlage.Selbstzahler) && (KontextregelHelper.containsAnyValue(fields.get("8627"), owner) || KontextregelHelper.containsAnyValue(fields.get("4111"), owner))) {
            return false;
        }
        return feld8626 != TestungRechtsgrundlage.Selbstzahler || !KontextregelHelper.containsAnyValue(fields.get("8617"), owner) && !KontextregelHelper.containsAnyValue(fields.get("8618"), owner) && !KontextregelHelper.containsAnyValue(fields.get("8619"), owner) && !KontextregelHelper.containsAnyValue(fields.get("8620"), owner);
    }
}

