/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Scheinuntergruppe;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K116
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K116.class);
    private static final Set<String> FIELDTYPES = Set.of("4239", "0222", "0212", "0223");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        Scheinuntergruppe scheinuntergruppe = (Scheinuntergruppe)((Object)KontextregelHelper.getFieldValue(fields.get("4239"), owner));
        if (scheinuntergruppe != Scheinuntergruppe.Muster10A && KontextregelHelper.containsAnyValue(fields.get("0222"), owner) && !KontextregelHelper.containsAnyValue(fields.get("0212"), owner) && !KontextregelHelper.containsAnyValue(fields.get("0223"), owner)) {
            LOG.error("For other than Muster 10A either FK 0212 or 0223 must be present");
            return false;
        }
        if (scheinuntergruppe == Scheinuntergruppe.Muster10A && KontextregelHelper.containsAnyValue(fields.get("0222"), owner)) {
            if (!KontextregelHelper.containsAnyValue(fields.get("0212"), owner)) {
                LOG.error("For Muster 10A FK 0212 must be present");
                return false;
            }
            if (KontextregelHelper.containsAnyValue(fields.get("0223"), owner)) {
                LOG.error("For Muster 10A FK 0223 must not be present");
                return false;
            }
        }
        return true;
    }
}

