/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K115
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K115.class);
    private static final Set<String> FIELDTYPES = Set.of("0212", "0223");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        List lebenslangeArztnummer = (List)KontextregelHelper.getFieldValue(fields.get("0212"), owner);
        List pseudoLanrFuerKrankenhausaerzteRahmenAsvAbrechnung = (List)KontextregelHelper.getFieldValue(fields.get("0223"), owner);
        if (lebenslangeArztnummer != null && !lebenslangeArztnummer.isEmpty() || pseudoLanrFuerKrankenhausaerzteRahmenAsvAbrechnung != null && !pseudoLanrFuerKrankenhausaerzteRahmenAsvAbrechnung.isEmpty()) {
            return true;
        }
        LOG.error("Either lebenslangeArztnummer or pseudoLanrFuerKrankenhausaerzteRahmenAsvAbrechnung is required");
        return false;
    }
}

