/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Auftragsstatus;
import libldt3.model.enums.TestStatus;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K096
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K096.class);
    private static final Set<String> FIELDTYPES = Set.of("8401", "8418");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        Auftragsstatus status = (Auftragsstatus)((Object)fields.get("8401").get(owner));
        if (status == Auftragsstatus.Auftrag_abgeschlossen) {
            TestStatus testStatus = (TestStatus)((Object)fields.get("8418").get(owner));
            return testStatus != TestStatus.Ergebnis_folgt && testStatus != TestStatus.Ergebnis_ermittelt && testStatus != TestStatus.ErweiterteAnalytik_erforderlich;
        }
        return true;
    }
}

