/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Abrechnungsinfo;
import libldt3.model.enums.StatusPerson;
import libldt3.model.objekte.Veranlassungsgrund;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K094
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K094.class);
    private static final Set<String> FIELDTYPES = Set.of("7420", "7303", "3103", "3110", "8228");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        StatusPerson feld7420 = (StatusPerson)((Object)fields.get("7420").get(owner));
        Veranlassungsgrund.AbrechnungsinfoZurUntersuchung feld7303 = (Veranlassungsgrund.AbrechnungsinfoZurUntersuchung)fields.get("7303").get(owner);
        if (feld7420 == StatusPerson.Patient && (feld7303.value == Abrechnungsinfo.GKV_Laborfacharzt || feld7303.value == Abrechnungsinfo.GKV_LG || feld7303.value == Abrechnungsinfo.PKV_Laborfacharzt || feld7303.value == Abrechnungsinfo.ASV || feld7303.value == Abrechnungsinfo.GKV_Laborfacharzt_praeventiv || feld7303.value == Abrechnungsinfo.GKV_LG_praeventiv)) {
            return KontextregelHelper.containsAnyValue(fields.get("3103"), owner) && KontextregelHelper.containsAnyValue(fields.get("3110"), owner) && KontextregelHelper.containsAnyValue(fields.get("8228"), owner);
        }
        return true;
    }
}

