/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Laborart;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K083
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K083.class);
    private static final Set<String> FIELDTYPES = Set.of("7266", "8145", "8153");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        Laborart feld7266 = (Laborart)((Object)KontextregelHelper.getFieldValue(fields.get("7266"), owner));
        if (feld7266 == Laborart.Laborgemeinschaft || feld7266 == Laborart.Facharztlabor) {
            if (!KontextregelHelper.containsAnyValue(fields.get("8145"), owner)) {
                return false;
            }
            if (KontextregelHelper.containsAnyValue(fields.get("8153"), owner)) {
                return false;
            }
        }
        return true;
    }
}

