/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import libldt3.model.Kontext;
import libldt3.model.enums.Abrechnungsinfo;
import libldt3.model.objekte.Arztidentifikation;
import libldt3.model.objekte.Fliesstext;
import libldt3.model.objekte.Untersuchungsanforderung;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.saetze.Auftrag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K057
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K057.class);

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        if (!(owner instanceof Auftrag)) {
            LOG.warn("K057 expected Auftrag as context, but got {}. Invalidly returning true", owner.getClass());
            return true;
        }
        Auftrag auftrag = (Auftrag)owner;
        if (auftrag.untersuchungsanforderung == null || auftrag.untersuchungsanforderung.isEmpty()) {
            return true;
        }
        for (Untersuchungsanforderung untersuchungsanforderung : auftrag.untersuchungsanforderung) {
            if (untersuchungsanforderung.abrechnungsinfoZurUntersuchung != Abrechnungsinfo.ASV) continue;
            if (auftrag.einsenderidentifikation == null) {
                return false;
            }
            return this.isNotEmpty(auftrag.einsenderidentifikation.arztidentifikation) || this.isNotEmpty(auftrag.einsenderidentifikation.ueberweisungAn) || this.isNotEmpty(auftrag.einsenderidentifikation.ueberweisungVonAnderenAerzten);
        }
        return true;
    }

    public boolean isNotEmpty(Arztidentifikation arztidentifikation) {
        return arztidentifikation.asvTeamnummer != null && !arztidentifikation.asvTeamnummer.isEmpty();
    }

    public boolean isNotEmpty(Fliesstext fliesstext) {
        return fliesstext.text != null && !fliesstext.text.isEmpty();
    }
}

