/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Betriebsstaettenstatus;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K043
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K043.class);
    private static final Set<String> FIELDTYPES = Set.of("0204");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        List stati = (List)fields.get("0204").get(owner);
        if (stati == null || stati.isEmpty()) {
            LOG.error("Requires one or two states, got none");
            return false;
        }
        if (stati.size() == 1) {
            for (Betriebsstaettenstatus status : stati) {
                if (status != Betriebsstaettenstatus.Arztpraxis && status != Betriebsstaettenstatus.Laborarztpraxis && status != Betriebsstaettenstatus.Laborgemeinschaft && status != Betriebsstaettenstatus.sonstige_medizinischeEinrichtung) continue;
                return true;
            }
            LOG.error("Only one state given, need to be 1, 2, 3 or 4");
            return false;
        }
        if (stati.size() == 2) {
            boolean oneToFour = false;
            boolean fiveOrSix = false;
            for (Betriebsstaettenstatus status : stati) {
                if (status == Betriebsstaettenstatus.Arztpraxis || status == Betriebsstaettenstatus.Laborarztpraxis || status == Betriebsstaettenstatus.Laborgemeinschaft || status == Betriebsstaettenstatus.sonstige_medizinischeEinrichtung) {
                    oneToFour = true;
                    continue;
                }
                if (status != Betriebsstaettenstatus.Hauptbetriebsstaette && status != Betriebsstaettenstatus.Nebenbetriebsstaette) continue;
                fiveOrSix = true;
            }
            if (oneToFour && fiveOrSix) {
                return true;
            }
            LOG.error("Two states given, need to be 1, 2, 3 or 4 and 5 or 6");
            return false;
        }
        LOG.error("Requires one or two states, got {}", (Object)stati.size());
        return false;
    }
}

