/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.StatusRechnungsempfaenger;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K030
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K030.class);
    private static final Set<String> FIELDTYPES = Set.of("7421", "8147");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        StatusRechnungsempfaenger status = (StatusRechnungsempfaenger)((Object)KontextregelHelper.getFieldValue(fields.get("7421"), owner));
        if (!(status != StatusRechnungsempfaenger.EinsenderArzt && status != StatusRechnungsempfaenger.Einsender_sonstige && status != StatusRechnungsempfaenger.Versicherter && status != StatusRechnungsempfaenger.Rechnungsempfaenger && status != StatusRechnungsempfaenger.Bevollmaechtigter && status != StatusRechnungsempfaenger.Halter && status != StatusRechnungsempfaenger.Patient || KontextregelHelper.containsAnyValue(fields.get("8147"), owner))) {
            LOG.error("Status {} requires field 8147 to have a value", (Object)status);
            return false;
        }
        return true;
    }
}

