/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Gebuehrenordnung;
import libldt3.model.objekte.Untersuchungsabrechnung;
import libldt3.model.regel.format.F009;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K019
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K019.class);
    private static final Set<String> FIELDTYPES = Set.of("4121", "5001");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<Kontext, Map<String, Field>> fields = KontextregelHelper.findFieldsRecursive(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        Untersuchungsabrechnung.Untersuchungsabrechnung_Gebuehrenordnung gebuehrenordnung = (Untersuchungsabrechnung.Untersuchungsabrechnung_Gebuehrenordnung)KontextregelHelper.getFieldValue(fields.get(owner).get("4121"), owner);
        if (gebuehrenordnung == null) {
            return true;
        }
        if (gebuehrenordnung.value == Gebuehrenordnung.EBM || gebuehrenordnung.value == Gebuehrenordnung.BMAe || gebuehrenordnung.value == Gebuehrenordnung.EGO) {
            List gebuehrennummern = (List)KontextregelHelper.getFieldValue(fields.get(gebuehrenordnung).get("5001"), gebuehrenordnung);
            for (Untersuchungsabrechnung.Gebuehrennummer gebuehrennummer : gebuehrennummern) {
                if (new F009().isValid(gebuehrennummer.value)) continue;
                LOG.error("Invalid number " + gebuehrennummer.value);
                return false;
            }
        }
        return true;
    }
}

