/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K017
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K017.class);
    private static final Set<String> FIELDTYPES = Set.of("3112", "3121", "3114", "3124");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        return !this.checkExclusion(owner, fields, "3114", "3112") && !this.checkExclusion(owner, fields, "3124", "3121") && (KontextregelHelper.containsAnyValue(fields.get("3112"), owner) || KontextregelHelper.containsAnyValue(fields.get("3121"), owner));
    }

    public boolean checkExclusion(Object owner, Map<String, Field> fields, String first, String second) throws IllegalAccessException {
        String value = (String)fields.get(first).get(owner);
        if (value != null && !"D".equals(value) && KontextregelHelper.containsAnyValue(fields.get("4109"), owner) && KontextregelHelper.containsAnyValue(fields.get(second), owner)) {
            LOG.error("FK {} is present and not 'D'. Also FK 4109 is present. Then {} must not be present", (Object)first, (Object)second);
            return true;
        }
        return false;
    }
}

