/*
 * Decompiled with CFR 0.152.
 */
package libldt3.model.regel.kontext;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import libldt3.model.Kontext;
import libldt3.model.enums.Abrechnungsinfo;
import libldt3.model.enums.Satzart;
import libldt3.model.objekte.Untersuchungsanforderung;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.regel.kontext.KontextregelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K011
implements Kontextregel {
    private static final Logger LOG = LoggerFactory.getLogger(K011.class);
    private static final Set<String> FIELDTYPES = Set.of("8000", "8002", "7303", "8410");

    @Override
    public boolean isValid(Kontext owner) throws IllegalAccessException {
        Map<String, Field> fields = KontextregelHelper.findFields(owner, FIELDTYPES);
        if (fields.size() != FIELDTYPES.size()) {
            LOG.error("Class of {} must have fields {}", (Object)owner, FIELDTYPES);
            return false;
        }
        Abrechnungsinfo feld7303 = (Abrechnungsinfo)((Object)KontextregelHelper.getFieldValue(fields.get("7303"), owner));
        Satzart feld8000 = (Satzart)((Object)KontextregelHelper.getFieldValue(fields.get("8000"), owner));
        Object feld8002 = KontextregelHelper.getFieldValue(fields.get("8002"), owner);
        return feld8000 != Satzart.Auftrag || !(feld8002 instanceof Untersuchungsanforderung) || feld7303 != Abrechnungsinfo.GKV_LG && feld7303 != Abrechnungsinfo.GKV_LG_praeventiv || !KontextregelHelper.containsAnyValue(fields.get("8410"), owner);
    }
}

