/*
 * Decompiled with CFR 0.152.
 */
package libldt3;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import libldt3.LdtConstants;
import libldt3.annotations.Datenpaket;
import libldt3.annotations.Feld;
import libldt3.annotations.Feldart;
import libldt3.annotations.Objekt;
import libldt3.annotations.Regelsatz;
import libldt3.model.saetze.Satz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdtWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LdtWriter.class);
    private final LdtConstants.Mode mode;

    public LdtWriter(LdtConstants.Mode mode) {
        this.mode = mode;
    }

    public void write(List<Satz> data, String path) throws IOException {
        try (PrintWriter w = new PrintWriter(path, StandardCharsets.ISO_8859_1);){
            this.write(data, w);
        }
    }

    public void write(List<Satz> data, Path path) throws IOException {
        this.write(data, path.toString());
    }

    public void write(List<Satz> data, PrintWriter writer) throws IOException {
        try {
            for (Satz o : data) {
                this.handleOutput(o, writer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleOutput(Object o, PrintWriter writer) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, InvocationTargetException {
        Datenpaket datenpaket = o.getClass().getAnnotation(Datenpaket.class);
        if (datenpaket != null) {
            writer.printf("0138000%s\r\n", datenpaket.value().code);
        }
        this.writeObjekt(o, writer);
        if (datenpaket != null) {
            writer.printf("0138001%s\r\n", datenpaket.value().code);
        }
    }

    private void writeObjekt(Object o, PrintWriter writer) throws IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        Objekt objekt = o.getClass().getAnnotation(Objekt.class);
        if (objekt != null && !objekt.value().isEmpty()) {
            writer.printf("0178002Obj_%s\r\n", objekt.value());
        }
        for (Field field : o.getClass().getDeclaredFields()) {
            Feld feld = field.getAnnotation(Feld.class);
            if (feld == null) continue;
            field.setAccessible(true);
            Object object = field.get(o);
            if (object == null) continue;
            if (object instanceof List) {
                for (Object o1 : (List)object) {
                    this.writeTextualRepresentation(field, writer, feld, o1);
                    this.handleOutput(o1, writer);
                }
                continue;
            }
            this.writeTextualRepresentation(field, writer, feld, object);
            this.handleOutput(object, writer);
        }
        if (objekt != null && !objekt.value().isEmpty()) {
            writer.printf("0178003Obj_%s\r\n", objekt.value());
        }
    }

    private void writeLdtLine(PrintWriter writer, Feld feld, String text) {
        writer.printf("%03d%s%s\r\n", text.length() + 9, feld.value(), text);
    }

    private void writeTextualRepresentation(Field field, PrintWriter writer, Feld feld, Object object) throws NoSuchFieldException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String name;
        if (feld.feldart() == Feldart.muss && object == null) {
            if (this.mode == LdtConstants.Mode.STRICT) {
                throw new IllegalArgumentException("Cannot get textual representation of null when writing feld " + String.valueOf(feld));
            }
            LOG.warn("Cannot get textual representation of null when writing feld {}, assuming empty string", (Object)feld);
            this.writeLdtLine(writer, feld, "");
            return;
        }
        if (object instanceof String) {
            String value = (String)object;
            for (Regelsatz regelsatz : (Regelsatz[])field.getAnnotationsByType(Regelsatz.class)) {
                if (regelsatz.maxLaenge() >= 0) {
                    if (value.length() <= regelsatz.maxLaenge()) continue;
                    if (this.mode == LdtConstants.Mode.STRICT) {
                        throw new IllegalArgumentException(String.format("Value %s must have maximum length of %d, but was %d", value, regelsatz.maxLaenge(), value.length()));
                    }
                    LOG.warn("{}.{}: Value {} must have maximum length of {}, but was {}, trimming", new Object[]{field.getDeclaringClass().getSimpleName(), field.getName(), value, regelsatz.maxLaenge(), value.length()});
                    value = value.substring(0, Math.min(value.length(), regelsatz.maxLaenge()));
                    continue;
                }
                if (regelsatz.laenge() < 0) continue;
                if (value.length() > regelsatz.laenge()) {
                    if (this.mode == LdtConstants.Mode.STRICT) {
                        throw new IllegalArgumentException(String.format("%s.%s: Value %s must have exact length of %d, but was %d", field.getDeclaringClass().getSimpleName(), field.getName(), value, regelsatz.laenge(), value.length()));
                    }
                    LOG.warn("{}.{}: Value {} must have exact length of {}, but was {}, trimming", new Object[]{field.getDeclaringClass().getSimpleName(), field.getName(), value, regelsatz.laenge(), value.length()});
                    value = value.substring(0, regelsatz.laenge());
                    continue;
                }
                if (value.length() >= regelsatz.laenge()) continue;
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalArgumentException(String.format("%s.%s: Value %s must have exact length of %d, but was %d", field.getDeclaringClass().getSimpleName(), field.getName(), value, regelsatz.laenge(), value.length()));
                }
                LOG.warn("{}.{}: Value {} must have exact length of {}, but was {}, ignoring", new Object[]{field.getDeclaringClass().getSimpleName(), field.getName(), value, regelsatz.laenge(), value.length()});
            }
            this.writeLdtLine(writer, feld, value);
            return;
        }
        if (object instanceof Float) {
            this.writeLdtLine(writer, feld, object.toString());
            return;
        }
        if (object instanceof Integer) {
            this.writeLdtLine(writer, feld, object.toString());
            return;
        }
        if (object instanceof Boolean) {
            this.writeLdtLine(writer, feld, object.equals(Boolean.TRUE) ? "1" : "0");
            return;
        }
        if (object instanceof LocalDate) {
            this.writeLdtLine(writer, feld, ((LocalDate)object).format(LdtConstants.FORMAT_DATE));
            return;
        }
        if (object instanceof LocalTime) {
            this.writeLdtLine(writer, feld, ((LocalTime)object).format(LdtConstants.FORMAT_TIME));
            return;
        }
        if (Enum.class.isAssignableFrom(object.getClass())) {
            Field codeField = object.getClass().getDeclaredField("code");
            this.writeLdtLine(writer, feld, (String)codeField.get(object));
            return;
        }
        Objekt annotation = object.getClass().getAnnotation(Objekt.class);
        if (annotation != null && annotation.value().isEmpty()) {
            try {
                Field declaredField = object.getClass().getDeclaredField("value");
                declaredField.setAccessible(true);
                Object innerObject = declaredField.get(object);
                this.writeTextualRepresentation(declaredField, writer, feld, innerObject);
                Objekt innerAnnotation = innerObject.getClass().getAnnotation(Objekt.class);
                if (innerAnnotation != null && !innerAnnotation.value().isEmpty()) {
                    this.writeObjekt(innerObject, writer);
                }
                return;
            }
            catch (NoSuchFieldException e) {
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalStateException(e);
                }
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((name = feld.name()).isEmpty()) {
            name = annotation != null && !annotation.name().isEmpty() ? annotation.name() : object.getClass().getSimpleName();
        }
        this.writeLdtLine(writer, feld, name);
    }
}

