/*
 * Decompiled with CFR 0.152.
 */
package libldt3;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import libldt3.LdtConstants;
import libldt3.annotations.Datenpaket;
import libldt3.annotations.Feld;
import libldt3.annotations.Objekt;
import libldt3.annotations.Regelsatz;
import libldt3.model.Kontext;
import libldt3.model.enums.Satzart;
import libldt3.model.regel.Regel;
import libldt3.model.regel.kontext.Kontextregel;
import libldt3.model.saetze.Auftrag;
import libldt3.model.saetze.Befund;
import libldt3.model.saetze.LaborDatenpaketAbschluss;
import libldt3.model.saetze.LaborDatenpaketHeader;
import libldt3.model.saetze.PraxisDatenpaketAbschluss;
import libldt3.model.saetze.PraxisDatenpaketHeader;
import libldt3.model.saetze.Satz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdtReader {
    private static final Logger LOG = LoggerFactory.getLogger(LdtReader.class);
    private final Map<Class<? extends Regel>, Regel> regelCache = new HashMap<Class<? extends Regel>, Regel>();
    private final LdtConstants.Mode mode;

    public LdtReader(LdtConstants.Mode mode) {
        this.mode = mode;
    }

    public List<Satz> read(String path) throws IOException {
        return this.read(Paths.get(path, new String[0]));
    }

    public List<Satz> read(Path path) throws IOException {
        try (Stream<String> stream = Files.lines(path, StandardCharsets.ISO_8859_1);){
            List<Satz> list = this.read(stream);
            return list;
        }
    }

    public List<Satz> read(Stream<String> stream) {
        LinkedList stack = new LinkedList();
        ArrayList<Satz> data = new ArrayList<Satz>();
        AtomicInteger integer = new AtomicInteger();
        stream.forEach(line -> this.handleInput((String)line, stack, (List<Satz>)data, integer.incrementAndGet()));
        return data;
    }

    private void handleInput(String line, Deque<Kontext> stack, List<Satz> data, int lineNo) {
        int length;
        LOG.trace("Reading line {}", (Object)line);
        if (line.length() < 7) {
            if (this.mode == LdtConstants.Mode.STRICT) {
                throw new IllegalArgumentException(String.format("Line '%s' was less than 7 characters, aborting", line));
            }
            LOG.error("Line '{}' was less than 7 characters, continuing anyway", (Object)line);
        }
        if ((length = Integer.parseInt(line.substring(0, 3))) != line.length() + 2) {
            if (this.mode == LdtConstants.Mode.STRICT) {
                throw new IllegalArgumentException(String.format("Line '%s' should have length %d, but was %d", line, line.length() + 2, length));
            }
            LOG.warn("Line '{}' should have length {}, but was {}. Ignoring specified length", new Object[]{line, line.length() + 2, length});
            length = line.length() + 2;
        }
        String identifier = line.substring(3, 7);
        String payload = line.substring(7, length - 2);
        block7 : switch (identifier) {
            case "8000": {
                this.assureLength(line, length, 13);
                if (!stack.isEmpty()) {
                    if (this.mode == LdtConstants.Mode.STRICT) {
                        throw new IllegalStateException("Stack must be empty when starting a new Satz, but was " + stack.size() + " long");
                    }
                    LOG.error("Stack must be empty when starting a new Satz, but was {}. Clearing and continuing", stack);
                    stack.clear();
                }
                Satzart satzart = this.getSatzart(payload);
                switch (satzart) {
                    case Befund: {
                        stack.push(new Befund());
                        break block7;
                    }
                    case Auftrag: {
                        stack.push(new Auftrag());
                        break block7;
                    }
                    case LaborDatenpaketHeader: {
                        stack.push(new LaborDatenpaketHeader());
                        break block7;
                    }
                    case LaborDatenpaketAbschluss: {
                        stack.push(new LaborDatenpaketAbschluss());
                        break block7;
                    }
                    case PraxisDatenpaketHeader: {
                        stack.push(new PraxisDatenpaketHeader());
                        break block7;
                    }
                    case PraxisDatenpaketAbschluss: {
                        stack.push(new PraxisDatenpaketAbschluss());
                        break block7;
                    }
                }
                throw new IllegalArgumentException("Unsupported Satzart '" + payload + "' found");
            }
            case "8001": {
                this.assureLength(line, length, 13);
                Kontext o = stack.pop();
                Datenpaket annotation = o.getClass().getAnnotation(Datenpaket.class);
                if (annotation != null) {
                    this.evaluateContextRules(o, annotation.kontextregeln());
                }
                if (!stack.isEmpty()) break;
                data.add((Satz)((Object)o));
                break;
            }
            case "8002": {
                this.assureLength(line, length, 17);
                Kontext currentObject = LdtReader.peekCurrentObject(stack);
                Objekt annotation = currentObject.getClass().getAnnotation(Objekt.class);
                if (annotation != null && !annotation.value().isEmpty()) {
                    if (payload.equals("Obj_" + annotation.value())) break;
                    if (this.mode == LdtConstants.Mode.STRICT) {
                        throw new IllegalArgumentException("In line '" + line + "' (" + lineNo + ") expected Obj_" + annotation.value() + ", got " + payload);
                    }
                    LOG.error("In line '{}' ({}) expected Obj_{}, got {}", new Object[]{line, lineNo, annotation.value(), payload});
                    break;
                }
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalArgumentException(String.format("Line '%s' started an unexpeted object", line));
                }
                LOG.warn("Line '{}' started an unexpeted object, stack was {}", (Object)line, stack);
                break;
            }
            case "8003": {
                Kontext o;
                Objekt annotation;
                this.assureLength(line, length, 17);
                do {
                    if ((annotation = (o = stack.pop()).getClass().getAnnotation(Objekt.class)) == null) continue;
                    if (!annotation.value().isEmpty() && !("Obj_" + annotation.value()).equals(payload)) {
                        LOG.warn("Line: {} ({}), annotation {}, payload {}", new Object[]{line, lineNo, annotation.value(), payload});
                    }
                    this.evaluateContextRules(o, annotation.kontextregeln());
                } while (annotation != null && annotation.value().isEmpty());
                if (!stack.isEmpty()) break;
                data.add((Satz)((Object)o));
                break;
            }
            default: {
                Kontext currentObject = LdtReader.peekCurrentObject(stack);
                if (currentObject == null) {
                    throw new IllegalStateException("No object when applying line " + line);
                }
                for (Field field : currentObject.getClass().getDeclaredFields()) {
                    Feld annotation = field.getAnnotation(Feld.class);
                    if (annotation == null || !identifier.equals(annotation.value())) continue;
                    field.setAccessible(true);
                    try {
                        Object object = field.get(currentObject);
                        if (object != null && !List.class.isAssignableFrom(field.getType())) {
                            if (this.mode == LdtConstants.Mode.STRICT) {
                                throw new IllegalStateException("Line '" + line + "' would overwrite existing value " + String.valueOf(object));
                            }
                            LOG.warn("Line '{}' would overwrite existing value {}", (Object)line, object);
                        }
                        this.validateFieldPayload(field, payload);
                        Object value = LdtReader.convertType(field, field.getType(), payload, stack);
                        field.set(currentObject, value);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        if (this.mode == LdtConstants.Mode.STRICT) {
                            throw new IllegalStateException(e);
                        }
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    return;
                }
                Objekt annotation = currentObject.getClass().getAnnotation(Objekt.class);
                if (annotation != null && annotation.value().isEmpty()) {
                    stack.pop();
                    this.handleInput(line, stack, data, lineNo);
                    return;
                }
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalArgumentException("Failed reading line " + line + " (" + lineNo + "), current stack: " + String.valueOf(stack));
                }
                LOG.warn("Failed reading line {} ({}), current stack: {}, skipping line", new Object[]{line, lineNo, stack});
            }
        }
    }

    private void evaluateContextRules(Kontext o, Class<? extends Kontextregel>[] kontextRegeln) {
        for (Class<? extends Kontextregel> kontextregel : kontextRegeln) {
            try {
                if (kontextregel.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).isValid(o)) continue;
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalArgumentException("Context rule " + kontextregel.getSimpleName() + " failed on object " + String.valueOf(o));
                }
                LOG.warn("Context rule {} failed on object {}", (Object)kontextregel.getSimpleName(), (Object)o);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (this.mode == LdtConstants.Mode.STRICT) {
                    throw new IllegalArgumentException("Context rule " + kontextregel.getSimpleName() + " failed on object " + String.valueOf(o), e);
                }
                LOG.warn("Context rule {} failed on object {}", new Object[]{kontextregel.getSimpleName(), o, e});
            }
        }
    }

    private void validateFieldPayload(Field field, String payload) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        for (Regelsatz regelsatz : (Regelsatz[])field.getAnnotationsByType(Regelsatz.class)) {
            if (regelsatz.laenge() >= 0 && payload.length() != regelsatz.laenge()) {
                this.validationFailed(String.format("%s.%s: Value %s did not match expected length %d, was %d", field.getDeclaringClass().getSimpleName(), field.getName(), payload, regelsatz.laenge(), payload.length()));
            }
            if (regelsatz.minLaenge() >= 0 && payload.length() < regelsatz.minLaenge()) {
                this.validationFailed(String.format("%s.%s: Value %s did not match expected minimum length %d, was %d", field.getDeclaringClass().getSimpleName(), field.getName(), payload, regelsatz.minLaenge(), payload.length()));
            }
            if (regelsatz.maxLaenge() >= 0 && payload.length() > regelsatz.maxLaenge()) {
                this.validationFailed(String.format("%s.%s: Value %s did not match expected maximum length %d, was %d", field.getDeclaringClass().getSimpleName(), field.getName(), payload, regelsatz.maxLaenge(), payload.length()));
            }
            if (regelsatz.value().length == 0) continue;
            boolean ok = false;
            for (Class<? extends Regel> regel : regelsatz.value()) {
                if (!this.getRegel(regel).isValid(payload)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            this.validationFailed(String.format("%s.%s: Value %s did not confirm to any rule of %s", field.getDeclaringClass().getSimpleName(), field.getName(), payload, this.toString(regelsatz.value())));
        }
    }

    private void validationFailed(String message) {
        if (this.mode == LdtConstants.Mode.STRICT) {
            throw new IllegalStateException(message);
        }
        LOG.warn(message);
    }

    private String toString(Class<? extends Regel>[] regeln) {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends Regel> regel : regeln) {
            if (buffer.length() > 0) {
                buffer.append(" or ");
            }
            buffer.append(regel.getSimpleName());
        }
        return buffer.toString();
    }

    private Regel getRegel(Class<? extends Regel> regel) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Regel instance = this.regelCache.get(regel);
        if (instance == null) {
            instance = regel.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.regelCache.put(regel, instance);
        }
        return instance;
    }

    private Satzart getSatzart(String payload) {
        Satzart satzart = null;
        for (Satzart sa : Satzart.values()) {
            if (!sa.code.equals(payload)) continue;
            satzart = sa;
            break;
        }
        return satzart;
    }

    private static Kontext peekCurrentObject(Deque<Kontext> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    private void assureLength(String line, int length, int target) {
        if (length != target) {
            if (this.mode == LdtConstants.Mode.STRICT) {
                throw new IllegalArgumentException("Line '" + line + "' must have length " + target + ", was " + length);
            }
            LOG.warn("Line '{}' must have length {}, was {}", new Object[]{line, target, length});
        }
    }

    private static Object convertType(Field field, Type type, String payload, Deque<Kontext> stack) throws NoSuchFieldException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        if (type == String.class) {
            return payload;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(payload);
        }
        if (type == Integer.class) {
            return Integer.valueOf(payload);
        }
        if (type == Boolean.class) {
            return "1".equals(payload);
        }
        if (type == Temporal.class) {
            if (payload.endsWith("00000000")) {
                return null;
            }
            if (payload.endsWith("0000")) {
                return Year.parse(payload.substring(0, payload.length() - 4));
            }
            if (payload.endsWith("00")) {
                return YearMonth.parse(payload.substring(0, payload.length() - 2), LdtConstants.FORMAT_DATE_YEAR_MONTH);
            }
            return LocalDate.parse(payload, LdtConstants.FORMAT_DATE);
        }
        if (type == LocalTime.class) {
            return LocalTime.parse(payload, LdtConstants.FORMAT_TIME);
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            Field codeField = ((Class)type).getDeclaredField("code");
            for (Object e : EnumSet.allOf((Class)type)) {
                String code = (String)codeField.get(e);
                if (!payload.equals(code)) continue;
                return e;
            }
            return null;
        }
        if (type instanceof Class && ((Class)type).isAssignableFrom(List.class)) {
            Kontext currentObject = LdtReader.peekCurrentObject(stack);
            ArrayList<Object> object = (ArrayList<Object>)field.get(currentObject);
            if (object == null) {
                object = new ArrayList<Object>();
                field.set(currentObject, object);
            }
            object.add(LdtReader.convertType(field, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], payload, stack));
            return object;
        }
        if (type instanceof Class && ((Class)type).getAnnotation(Objekt.class) != null) {
            Kontext instance = (Kontext)((Class)type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            stack.push(instance);
            try {
                Field declaredField = ((Class)type).getDeclaredField("value");
                declaredField.setAccessible(true);
                declaredField.set(instance, LdtReader.convertType(declaredField, declaredField.getType(), payload, stack));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return instance;
        }
        throw new IllegalArgumentException("Don't know how to handle type " + String.valueOf(type));
    }
}

