/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.markup.multimarkdown;

import de.edgesoft.edgeutils.markup.latex.LaTeXMarkup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MMDMarkup {
    public static final String LATEX = "`%s`{=latex}";
    public static final String LATEX_BLOCK = "```{=latex}\n%s\n```\n";
    public static final String LATEX_CONTENT = "`{=latex}%s`";
    public static final String HEADING_TOKEN = "#";
    public static final String HEADING = "%s %%s [%%s]\n\n";
    public static final String MINISEC = String.format("%s\n\n", String.format("`%s`{=latex}", String.format("\\minisec{%s}\n\n", "`{=latex}%s`"))).replace(String.format("`%s`{=latex}", "}\n\n"), String.format("`%s`{=latex}", "}"));
    public static final String EMPH = "*%s*";
    public static final String BOLD = "**%s**";
    public static final String TEXTCOLOR_NAMED = String.format("`%s`{=latex}", String.format("\\textcolor{%s}{%s}", "%s", "`{=latex}%s`"));
    public static final String BGCOLOR_NAMED = String.format("`%s`{=latex}", String.format("\\colorbox{%s}{%s}", "%s", "`{=latex}%s`"));
    public static final String TEXTCOLOR_RGB = String.format("`%s`{=latex}", "\\textcolor[rgb]{%.2f,%.2f,%.2f}{%%s}");
    public static final String BGCOLOR_RGB = String.format("`%s`{=latex}", "\\colorbox[rgb]{%.2f,%.2f,%.2f}{%%s}");
    public static final String FOOTNOTE_REFERENCE = "[%s]";
    public static final String FOOTNOTE_DEFINITION = "[%s]: %s\n\n";
    public static final String TEXT_REFERENCE = "[%s][%s]";
    public static final String TABBING_START = String.format("%s\n", String.format("`%s`{=latex}", String.format("\\begin{tabbing}\n\t%s\\=\\kill\n", "`{=latex}%s`")));
    public static final String TABBING_LINE = String.format("%s\n", String.format("`%s`{=latex}", String.format("\t%s\\>%s\\\\\n", "`{=latex}%s`", "`{=latex}%s`")));
    public static final String TABBING_END = String.format("%s\n\n", String.format("`%s`{=latex}", "\\end{tabbing}\n\n", "`{=latex}%s`"));
    public static final String REPLACEMENT_TOKEN = String.format("**%s**", "generated %s");

    public static String getHeadingToken(int iLevel) {
        if (iLevel >= 4) {
            return MINISEC;
        }
        char[] arrFilled = new char[iLevel];
        Arrays.fill(arrFilled, '#');
        return String.format(HEADING, new String(arrFilled));
    }

    public static String getRGBColorToken(String theToken, Color theColor) {
        return String.format(LaTeXMarkup.getRGBColorToken(theToken, theColor), LATEX_CONTENT);
    }

    public static String getTableStartToken(String theTableName, List<String> theHeadings, List<Double> theColWidths, boolean isHeadingBold, String theRule) {
        ArrayList<String> lstHeadings = new ArrayList<String>();
        if (theHeadings != null) {
            for (String theHeading : theHeadings) {
                lstHeadings.add(isHeadingBold ? String.format("\\textbf{%s}", theHeading) : theHeading);
            }
        }
        return String.format(LATEX_BLOCK, LaTeXMarkup.getTableStartToken(theTableName, lstHeadings, theColWidths, false, theRule));
    }

    public static String getTableLineToken(List<String> theContent, String theRule) {
        return LaTeXMarkup.getTableLineToken(theContent, theRule).replace(" & ", String.format(LATEX, " & ")).replace("\\\\", String.format(LATEX, "\\\\")).replace("\t", "");
    }

    public static String getTableEndToken(String theTableName) {
        return String.format(LATEX_BLOCK, LaTeXMarkup.getTableEndToken(theTableName));
    }
}

