/*
 * Decompiled with CFR 0.152.
 */
package de.edgesoft.edgeutils.markup.latex;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LaTeXMarkup {
    public static final String BOLD = "\\textbf{%s}";
    public static final String MINISEC = "\\minisec{%s}\n\n";
    public static final String TEXTCOLOR_NAMED = "\\textcolor{%s}{%s}";
    public static final String BGCOLOR_NAMED = "\\colorbox{%s}{%s}";
    public static final String TEXTCOLOR_RGB = "\\textcolor[rgb]{%.2f,%.2f,%.2f}{%%s}";
    public static final String BGCOLOR_RGB = "\\colorbox[rgb]{%.2f,%.2f,%.2f}{%%s}";
    public static final String TABBING_START = "\\begin{tabbing}\n\t%s\\=\\kill\n";
    public static final String TABBING_LINE = "\t%s\\>%s\\\\\n";
    public static final String TABBING_END = "\\end{tabbing}\n\n";
    public static final String TABLE_START = "\n\\begin{%s}\n\t{@{}%s@{}}\n%s\n\n";
    public static final String TABLE_LINE = "\t%s\\\\\n";
    public static final String TABLE_SEP = " & ";
    public static final String TABLE_RULE = "\t%s\n";
    public static final String TABLE_END = "\n\\end{%s}\n\n";

    public static String getRGBColorToken(String theToken, Color theColor) {
        return String.format(Locale.ENGLISH, theToken, Float.valueOf(theColor.getRGBComponents(null)[0]), Float.valueOf(theColor.getRGBComponents(null)[1]), Float.valueOf(theColor.getRGBComponents(null)[2]));
    }

    public static String getTableStartToken(String theTableName, List<String> theHeadings, List<Double> theColWidths, boolean isHeadingBold, String theRule) {
        String sTableName = theTableName == null ? "longtable" : theTableName;
        StringBuilder sbCols = new StringBuilder();
        boolean bMore = false;
        for (Double theColWidth : theColWidths) {
            if (bMore) {
                sbCols.append("@{\\hspace{.02\\textwidth}}");
            }
            bMore = true;
            sbCols.append(String.format(Locale.ENGLISH, ">{\\RaggedRight}p{%.2f\\textwidth}", theColWidth));
        }
        StringBuilder sbHead = new StringBuilder();
        if (theHeadings != null && !theHeadings.isEmpty()) {
            ArrayList<String> lstHeadings = new ArrayList<String>();
            for (String theHeading : theHeadings) {
                lstHeadings.add(isHeadingBold ? String.format(BOLD, theHeading) : theHeading);
            }
            sbHead.append(LaTeXMarkup.getTableLineToken(lstHeadings, theRule));
            sbHead.append("\\endhead");
        }
        return String.format(TABLE_START, sTableName, sbCols.toString(), sbHead.toString());
    }

    public static String getTableLineToken(List<String> theContent, String theRule) {
        StringBuilder sbContent = new StringBuilder();
        if (theContent != null && !theContent.isEmpty()) {
            boolean bMore = false;
            for (String theCellContent : theContent) {
                if (bMore) {
                    sbContent.append(TABLE_SEP);
                }
                sbContent.append(theCellContent);
                bMore = true;
            }
        }
        StringBuilder sbReturn = new StringBuilder();
        sbReturn.append(String.format(TABLE_LINE, sbContent.toString()));
        if (theRule != null) {
            sbReturn.append(String.format(TABLE_RULE, theRule));
        }
        return sbReturn.toString();
    }

    public static String getTableEndToken(String theTableName) {
        return String.format(TABLE_END, theTableName == null ? "longtable" : theTableName);
    }
}

